/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._core.search;

import co.elastic.clients.elasticsearch._core.search.DirectGenerator;
import co.elastic.clients.elasticsearch._core.search.PhraseSuggestCollate;
import co.elastic.clients.elasticsearch._core.search.PhraseSuggestHighlight;
import co.elastic.clients.elasticsearch._core.search.SmoothingModel;
import co.elastic.clients.elasticsearch._core.search.SuggestVariant;
import co.elastic.clients.elasticsearch._core.search.SuggesterBase;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class PhraseSuggester
extends SuggesterBase
implements SuggestVariant {
    @Nullable
    private final PhraseSuggestCollate collate;
    @Nullable
    private final Double confidence;
    @Nullable
    private final List<DirectGenerator> directGenerator;
    @Nullable
    private final Boolean forceUnigrams;
    @Nullable
    private final Integer gramSize;
    @Nullable
    private final PhraseSuggestHighlight highlight;
    @Nullable
    private final Double maxErrors;
    @Nullable
    private final Double realWordErrorLikelihood;
    @Nullable
    private final String separator;
    @Nullable
    private final Integer shardSize;
    @Nullable
    private final SmoothingModel smoothing;
    @Nullable
    private final String text;
    @Nullable
    private final Integer tokenLimit;
    public static final JsonpDeserializer<PhraseSuggester> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PhraseSuggester::setupPhraseSuggesterDeserializer, Builder::build);

    public PhraseSuggester(Builder builder) {
        super(builder);
        this.collate = builder.collate;
        this.confidence = builder.confidence;
        this.directGenerator = ModelTypeHelper.unmodifiable(builder.directGenerator);
        this.forceUnigrams = builder.forceUnigrams;
        this.gramSize = builder.gramSize;
        this.highlight = builder.highlight;
        this.maxErrors = builder.maxErrors;
        this.realWordErrorLikelihood = builder.realWordErrorLikelihood;
        this.separator = builder.separator;
        this.shardSize = builder.shardSize;
        this.smoothing = builder.smoothing;
        this.text = builder.text;
        this.tokenLimit = builder.tokenLimit;
    }

    public PhraseSuggester(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "phrase";
    }

    @Nullable
    public PhraseSuggestCollate collate() {
        return this.collate;
    }

    @Nullable
    public Double confidence() {
        return this.confidence;
    }

    @Nullable
    public List<DirectGenerator> directGenerator() {
        return this.directGenerator;
    }

    @Nullable
    public Boolean forceUnigrams() {
        return this.forceUnigrams;
    }

    @Nullable
    public Integer gramSize() {
        return this.gramSize;
    }

    @Nullable
    public PhraseSuggestHighlight highlight() {
        return this.highlight;
    }

    @Nullable
    public Double maxErrors() {
        return this.maxErrors;
    }

    @Nullable
    public Double realWordErrorLikelihood() {
        return this.realWordErrorLikelihood;
    }

    @Nullable
    public String separator() {
        return this.separator;
    }

    @Nullable
    public Integer shardSize() {
        return this.shardSize;
    }

    @Nullable
    public SmoothingModel smoothing() {
        return this.smoothing;
    }

    @Nullable
    public String text() {
        return this.text;
    }

    @Nullable
    public Integer tokenLimit() {
        return this.tokenLimit;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.collate != null) {
            generator.writeKey("collate");
            this.collate.serialize(generator, mapper);
        }
        if (this.confidence != null) {
            generator.writeKey("confidence");
            generator.write(this.confidence.doubleValue());
        }
        if (this.directGenerator != null) {
            generator.writeKey("direct_generator");
            generator.writeStartArray();
            for (DirectGenerator item0 : this.directGenerator) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.forceUnigrams != null) {
            generator.writeKey("force_unigrams");
            generator.write(this.forceUnigrams.booleanValue());
        }
        if (this.gramSize != null) {
            generator.writeKey("gram_size");
            generator.write(this.gramSize.intValue());
        }
        if (this.highlight != null) {
            generator.writeKey("highlight");
            this.highlight.serialize(generator, mapper);
        }
        if (this.maxErrors != null) {
            generator.writeKey("max_errors");
            generator.write(this.maxErrors.doubleValue());
        }
        if (this.realWordErrorLikelihood != null) {
            generator.writeKey("real_word_error_likelihood");
            generator.write(this.realWordErrorLikelihood.doubleValue());
        }
        if (this.separator != null) {
            generator.writeKey("separator");
            generator.write(this.separator);
        }
        if (this.shardSize != null) {
            generator.writeKey("shard_size");
            generator.write(this.shardSize.intValue());
        }
        if (this.smoothing != null) {
            generator.writeKey("smoothing");
            this.smoothing.serialize(generator, mapper);
        }
        if (this.text != null) {
            generator.writeKey("text");
            generator.write(this.text);
        }
        if (this.tokenLimit != null) {
            generator.writeKey("token_limit");
            generator.write(this.tokenLimit.intValue());
        }
    }

    protected static void setupPhraseSuggesterDeserializer(DelegatingDeserializer<Builder> op) {
        SuggesterBase.setupSuggesterBaseDeserializer(op);
        op.add(Builder::collate, PhraseSuggestCollate._DESERIALIZER, "collate", new String[0]);
        op.add(Builder::confidence, JsonpDeserializer.doubleDeserializer(), "confidence", new String[0]);
        op.add(Builder::directGenerator, JsonpDeserializer.arrayDeserializer(DirectGenerator._DESERIALIZER), "direct_generator", new String[0]);
        op.add(Builder::forceUnigrams, JsonpDeserializer.booleanDeserializer(), "force_unigrams", new String[0]);
        op.add(Builder::gramSize, JsonpDeserializer.integerDeserializer(), "gram_size", new String[0]);
        op.add(Builder::highlight, PhraseSuggestHighlight._DESERIALIZER, "highlight", new String[0]);
        op.add(Builder::maxErrors, JsonpDeserializer.doubleDeserializer(), "max_errors", new String[0]);
        op.add(Builder::realWordErrorLikelihood, JsonpDeserializer.doubleDeserializer(), "real_word_error_likelihood", new String[0]);
        op.add(Builder::separator, JsonpDeserializer.stringDeserializer(), "separator", new String[0]);
        op.add(Builder::shardSize, JsonpDeserializer.integerDeserializer(), "shard_size", new String[0]);
        op.add(Builder::smoothing, SmoothingModel._DESERIALIZER, "smoothing", new String[0]);
        op.add(Builder::text, JsonpDeserializer.stringDeserializer(), "text", new String[0]);
        op.add(Builder::tokenLimit, JsonpDeserializer.integerDeserializer(), "token_limit", new String[0]);
    }

    public static class Builder
    extends SuggesterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PhraseSuggester> {
        @Nullable
        private PhraseSuggestCollate collate;
        @Nullable
        private Double confidence;
        @Nullable
        private List<DirectGenerator> directGenerator;
        @Nullable
        private Boolean forceUnigrams;
        @Nullable
        private Integer gramSize;
        @Nullable
        private PhraseSuggestHighlight highlight;
        @Nullable
        private Double maxErrors;
        @Nullable
        private Double realWordErrorLikelihood;
        @Nullable
        private String separator;
        @Nullable
        private Integer shardSize;
        @Nullable
        private SmoothingModel smoothing;
        @Nullable
        private String text;
        @Nullable
        private Integer tokenLimit;

        public Builder collate(@Nullable PhraseSuggestCollate value) {
            this.collate = value;
            return this;
        }

        public Builder collate(Function<PhraseSuggestCollate.Builder, ObjectBuilder<PhraseSuggestCollate>> fn) {
            return this.collate(fn.apply(new PhraseSuggestCollate.Builder()).build());
        }

        public Builder confidence(@Nullable Double value) {
            this.confidence = value;
            return this;
        }

        public Builder directGenerator(@Nullable List<DirectGenerator> value) {
            this.directGenerator = value;
            return this;
        }

        public Builder directGenerator(DirectGenerator ... value) {
            this.directGenerator = Arrays.asList(value);
            return this;
        }

        public Builder addDirectGenerator(DirectGenerator value) {
            if (this.directGenerator == null) {
                this.directGenerator = new ArrayList<DirectGenerator>();
            }
            this.directGenerator.add(value);
            return this;
        }

        public Builder directGenerator(Function<DirectGenerator.Builder, ObjectBuilder<DirectGenerator>> fn) {
            return this.directGenerator(fn.apply(new DirectGenerator.Builder()).build());
        }

        public Builder addDirectGenerator(Function<DirectGenerator.Builder, ObjectBuilder<DirectGenerator>> fn) {
            return this.addDirectGenerator(fn.apply(new DirectGenerator.Builder()).build());
        }

        public Builder forceUnigrams(@Nullable Boolean value) {
            this.forceUnigrams = value;
            return this;
        }

        public Builder gramSize(@Nullable Integer value) {
            this.gramSize = value;
            return this;
        }

        public Builder highlight(@Nullable PhraseSuggestHighlight value) {
            this.highlight = value;
            return this;
        }

        public Builder highlight(Function<PhraseSuggestHighlight.Builder, ObjectBuilder<PhraseSuggestHighlight>> fn) {
            return this.highlight(fn.apply(new PhraseSuggestHighlight.Builder()).build());
        }

        public Builder maxErrors(@Nullable Double value) {
            this.maxErrors = value;
            return this;
        }

        public Builder realWordErrorLikelihood(@Nullable Double value) {
            this.realWordErrorLikelihood = value;
            return this;
        }

        public Builder separator(@Nullable String value) {
            this.separator = value;
            return this;
        }

        public Builder shardSize(@Nullable Integer value) {
            this.shardSize = value;
            return this;
        }

        public Builder smoothing(@Nullable SmoothingModel value) {
            this.smoothing = value;
            return this;
        }

        public Builder smoothing(Function<SmoothingModel.Builder, ObjectBuilder<SmoothingModel>> fn) {
            return this.smoothing(fn.apply(new SmoothingModel.Builder()).build());
        }

        public Builder text(@Nullable String value) {
            this.text = value;
            return this;
        }

        public Builder tokenLimit(@Nullable Integer value) {
            this.tokenLimit = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PhraseSuggester build() {
            return new PhraseSuggester(this);
        }
    }
}

