/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._core.reindex;

import co.elastic.clients.elasticsearch._types.OpType;
import co.elastic.clients.elasticsearch._types.VersionType;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class Destination
implements JsonpSerializable {
    @Nullable
    private final String index;
    @Nullable
    private final OpType opType;
    @Nullable
    private final String pipeline;
    @Nullable
    private final String routing;
    @Nullable
    private final VersionType versionType;
    public static final JsonpDeserializer<Destination> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Destination::setupDestinationDeserializer, Builder::build);

    public Destination(Builder builder) {
        this.index = builder.index;
        this.opType = builder.opType;
        this.pipeline = builder.pipeline;
        this.routing = builder.routing;
        this.versionType = builder.versionType;
    }

    public Destination(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public String index() {
        return this.index;
    }

    @Nullable
    public OpType opType() {
        return this.opType;
    }

    @Nullable
    public String pipeline() {
        return this.pipeline;
    }

    @Nullable
    public String routing() {
        return this.routing;
    }

    @Nullable
    public VersionType versionType() {
        return this.versionType;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.index != null) {
            generator.writeKey("index");
            generator.write(this.index);
        }
        if (this.opType != null) {
            generator.writeKey("op_type");
            this.opType.serialize(generator, mapper);
        }
        if (this.pipeline != null) {
            generator.writeKey("pipeline");
            generator.write(this.pipeline);
        }
        if (this.routing != null) {
            generator.writeKey("routing");
            generator.write(this.routing);
        }
        if (this.versionType != null) {
            generator.writeKey("version_type");
            this.versionType.serialize(generator, mapper);
        }
    }

    protected static void setupDestinationDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "index", new String[0]);
        op.add(Builder::opType, OpType._DESERIALIZER, "op_type", new String[0]);
        op.add(Builder::pipeline, JsonpDeserializer.stringDeserializer(), "pipeline", new String[0]);
        op.add(Builder::routing, JsonpDeserializer.stringDeserializer(), "routing", new String[0]);
        op.add(Builder::versionType, VersionType._DESERIALIZER, "version_type", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<Destination> {
        @Nullable
        private String index;
        @Nullable
        private OpType opType;
        @Nullable
        private String pipeline;
        @Nullable
        private String routing;
        @Nullable
        private VersionType versionType;

        public Builder index(@Nullable String value) {
            this.index = value;
            return this;
        }

        public Builder opType(@Nullable OpType value) {
            this.opType = value;
            return this;
        }

        public Builder pipeline(@Nullable String value) {
            this.pipeline = value;
            return this;
        }

        public Builder routing(@Nullable String value) {
            this.routing = value;
            return this;
        }

        public Builder versionType(@Nullable VersionType value) {
            this.versionType = value;
            return this;
        }

        @Override
        public Destination build() {
            return new Destination(this);
        }
    }
}

