/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._core.explain;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class ExplanationDetail
implements JsonpSerializable {
    private final String description;
    @Nullable
    private final List<ExplanationDetail> details;
    private final float value;
    public static final JsonpDeserializer<ExplanationDetail> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ExplanationDetail::setupExplanationDetailDeserializer, Builder::build);

    public ExplanationDetail(Builder builder) {
        this.description = Objects.requireNonNull(builder.description, "description");
        this.details = ModelTypeHelper.unmodifiable(builder.details);
        this.value = Objects.requireNonNull(builder.value, "value").floatValue();
    }

    public ExplanationDetail(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String description() {
        return this.description;
    }

    @Nullable
    public List<ExplanationDetail> details() {
        return this.details;
    }

    public float value() {
        return this.value;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("description");
        generator.write(this.description);
        if (this.details != null) {
            generator.writeKey("details");
            generator.writeStartArray();
            for (ExplanationDetail item0 : this.details) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("value");
        generator.write((double)this.value);
    }

    protected static void setupExplanationDetailDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description", new String[0]);
        op.add(Builder::details, JsonpDeserializer.arrayDeserializer(_DESERIALIZER), "details", new String[0]);
        op.add(Builder::value, JsonpDeserializer.floatDeserializer(), "value", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ExplanationDetail> {
        private String description;
        @Nullable
        private List<ExplanationDetail> details;
        private Float value;

        public Builder description(String value) {
            this.description = value;
            return this;
        }

        public Builder details(@Nullable List<ExplanationDetail> value) {
            this.details = value;
            return this;
        }

        public Builder details(ExplanationDetail ... value) {
            this.details = Arrays.asList(value);
            return this;
        }

        public Builder addDetails(ExplanationDetail value) {
            if (this.details == null) {
                this.details = new ArrayList<ExplanationDetail>();
            }
            this.details.add(value);
            return this;
        }

        public Builder details(Function<Builder, ObjectBuilder<ExplanationDetail>> fn) {
            return this.details(fn.apply(new Builder()).build());
        }

        public Builder addDetails(Function<Builder, ObjectBuilder<ExplanationDetail>> fn) {
            return this.addDetails(fn.apply(new Builder()).build());
        }

        public Builder value(float value) {
            this.value = Float.valueOf(value);
            return this;
        }

        @Override
        public ExplanationDetail build() {
            return new ExplanationDetail(this);
        }
    }
}

