/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._core;

import co.elastic.clients.elasticsearch._types.BulkIndexByScrollFailure;
import co.elastic.clients.elasticsearch._types.Retries;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class ReindexResponse
implements JsonpSerializable {
    @Nullable
    private final Long batches;
    @Nullable
    private final Long created;
    @Nullable
    private final Long deleted;
    @Nullable
    private final List<BulkIndexByScrollFailure> failures;
    @Nullable
    private final Long noops;
    @Nullable
    private final Retries retries;
    @Nullable
    private final Long requestsPerSecond;
    @Nullable
    private final Integer sliceId;
    @Nullable
    private final String task;
    @Nullable
    private final String throttledMillis;
    @Nullable
    private final String throttledUntilMillis;
    @Nullable
    private final Boolean timedOut;
    @Nullable
    private final String took;
    @Nullable
    private final Long total;
    @Nullable
    private final Long updated;
    @Nullable
    private final Long versionConflicts;
    public static final JsonpDeserializer<ReindexResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ReindexResponse::setupReindexResponseDeserializer, Builder::build);

    public ReindexResponse(Builder builder) {
        this.batches = builder.batches;
        this.created = builder.created;
        this.deleted = builder.deleted;
        this.failures = ModelTypeHelper.unmodifiable(builder.failures);
        this.noops = builder.noops;
        this.retries = builder.retries;
        this.requestsPerSecond = builder.requestsPerSecond;
        this.sliceId = builder.sliceId;
        this.task = builder.task;
        this.throttledMillis = builder.throttledMillis;
        this.throttledUntilMillis = builder.throttledUntilMillis;
        this.timedOut = builder.timedOut;
        this.took = builder.took;
        this.total = builder.total;
        this.updated = builder.updated;
        this.versionConflicts = builder.versionConflicts;
    }

    public ReindexResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public Long batches() {
        return this.batches;
    }

    @Nullable
    public Long created() {
        return this.created;
    }

    @Nullable
    public Long deleted() {
        return this.deleted;
    }

    @Nullable
    public List<BulkIndexByScrollFailure> failures() {
        return this.failures;
    }

    @Nullable
    public Long noops() {
        return this.noops;
    }

    @Nullable
    public Retries retries() {
        return this.retries;
    }

    @Nullable
    public Long requestsPerSecond() {
        return this.requestsPerSecond;
    }

    @Nullable
    public Integer sliceId() {
        return this.sliceId;
    }

    @Nullable
    public String task() {
        return this.task;
    }

    @Nullable
    public String throttledMillis() {
        return this.throttledMillis;
    }

    @Nullable
    public String throttledUntilMillis() {
        return this.throttledUntilMillis;
    }

    @Nullable
    public Boolean timedOut() {
        return this.timedOut;
    }

    @Nullable
    public String took() {
        return this.took;
    }

    @Nullable
    public Long total() {
        return this.total;
    }

    @Nullable
    public Long updated() {
        return this.updated;
    }

    @Nullable
    public Long versionConflicts() {
        return this.versionConflicts;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.batches != null) {
            generator.writeKey("batches");
            generator.write(this.batches.longValue());
        }
        if (this.created != null) {
            generator.writeKey("created");
            generator.write(this.created.longValue());
        }
        if (this.deleted != null) {
            generator.writeKey("deleted");
            generator.write(this.deleted.longValue());
        }
        if (this.failures != null) {
            generator.writeKey("failures");
            generator.writeStartArray();
            for (BulkIndexByScrollFailure item0 : this.failures) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.noops != null) {
            generator.writeKey("noops");
            generator.write(this.noops.longValue());
        }
        if (this.retries != null) {
            generator.writeKey("retries");
            this.retries.serialize(generator, mapper);
        }
        if (this.requestsPerSecond != null) {
            generator.writeKey("requests_per_second");
            generator.write(this.requestsPerSecond.longValue());
        }
        if (this.sliceId != null) {
            generator.writeKey("slice_id");
            generator.write(this.sliceId.intValue());
        }
        if (this.task != null) {
            generator.writeKey("task");
            generator.write(this.task);
        }
        if (this.throttledMillis != null) {
            generator.writeKey("throttled_millis");
            generator.write(this.throttledMillis);
        }
        if (this.throttledUntilMillis != null) {
            generator.writeKey("throttled_until_millis");
            generator.write(this.throttledUntilMillis);
        }
        if (this.timedOut != null) {
            generator.writeKey("timed_out");
            generator.write(this.timedOut.booleanValue());
        }
        if (this.took != null) {
            generator.writeKey("took");
            generator.write(this.took);
        }
        if (this.total != null) {
            generator.writeKey("total");
            generator.write(this.total.longValue());
        }
        if (this.updated != null) {
            generator.writeKey("updated");
            generator.write(this.updated.longValue());
        }
        if (this.versionConflicts != null) {
            generator.writeKey("version_conflicts");
            generator.write(this.versionConflicts.longValue());
        }
    }

    protected static void setupReindexResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::batches, JsonpDeserializer.longDeserializer(), "batches", new String[0]);
        op.add(Builder::created, JsonpDeserializer.longDeserializer(), "created", new String[0]);
        op.add(Builder::deleted, JsonpDeserializer.longDeserializer(), "deleted", new String[0]);
        op.add(Builder::failures, JsonpDeserializer.arrayDeserializer(BulkIndexByScrollFailure._DESERIALIZER), "failures", new String[0]);
        op.add(Builder::noops, JsonpDeserializer.longDeserializer(), "noops", new String[0]);
        op.add(Builder::retries, Retries._DESERIALIZER, "retries", new String[0]);
        op.add(Builder::requestsPerSecond, JsonpDeserializer.longDeserializer(), "requests_per_second", new String[0]);
        op.add(Builder::sliceId, JsonpDeserializer.integerDeserializer(), "slice_id", new String[0]);
        op.add(Builder::task, JsonpDeserializer.stringDeserializer(), "task", new String[0]);
        op.add(Builder::throttledMillis, JsonpDeserializer.stringDeserializer(), "throttled_millis", new String[0]);
        op.add(Builder::throttledUntilMillis, JsonpDeserializer.stringDeserializer(), "throttled_until_millis", new String[0]);
        op.add(Builder::timedOut, JsonpDeserializer.booleanDeserializer(), "timed_out", new String[0]);
        op.add(Builder::took, JsonpDeserializer.stringDeserializer(), "took", new String[0]);
        op.add(Builder::total, JsonpDeserializer.longDeserializer(), "total", new String[0]);
        op.add(Builder::updated, JsonpDeserializer.longDeserializer(), "updated", new String[0]);
        op.add(Builder::versionConflicts, JsonpDeserializer.longDeserializer(), "version_conflicts", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ReindexResponse> {
        @Nullable
        private Long batches;
        @Nullable
        private Long created;
        @Nullable
        private Long deleted;
        @Nullable
        private List<BulkIndexByScrollFailure> failures;
        @Nullable
        private Long noops;
        @Nullable
        private Retries retries;
        @Nullable
        private Long requestsPerSecond;
        @Nullable
        private Integer sliceId;
        @Nullable
        private String task;
        @Nullable
        private String throttledMillis;
        @Nullable
        private String throttledUntilMillis;
        @Nullable
        private Boolean timedOut;
        @Nullable
        private String took;
        @Nullable
        private Long total;
        @Nullable
        private Long updated;
        @Nullable
        private Long versionConflicts;

        public Builder batches(@Nullable Long value) {
            this.batches = value;
            return this;
        }

        public Builder created(@Nullable Long value) {
            this.created = value;
            return this;
        }

        public Builder deleted(@Nullable Long value) {
            this.deleted = value;
            return this;
        }

        public Builder failures(@Nullable List<BulkIndexByScrollFailure> value) {
            this.failures = value;
            return this;
        }

        public Builder failures(BulkIndexByScrollFailure ... value) {
            this.failures = Arrays.asList(value);
            return this;
        }

        public Builder addFailures(BulkIndexByScrollFailure value) {
            if (this.failures == null) {
                this.failures = new ArrayList<BulkIndexByScrollFailure>();
            }
            this.failures.add(value);
            return this;
        }

        public Builder failures(Function<BulkIndexByScrollFailure.Builder, ObjectBuilder<BulkIndexByScrollFailure>> fn) {
            return this.failures(fn.apply(new BulkIndexByScrollFailure.Builder()).build());
        }

        public Builder addFailures(Function<BulkIndexByScrollFailure.Builder, ObjectBuilder<BulkIndexByScrollFailure>> fn) {
            return this.addFailures(fn.apply(new BulkIndexByScrollFailure.Builder()).build());
        }

        public Builder noops(@Nullable Long value) {
            this.noops = value;
            return this;
        }

        public Builder retries(@Nullable Retries value) {
            this.retries = value;
            return this;
        }

        public Builder retries(Function<Retries.Builder, ObjectBuilder<Retries>> fn) {
            return this.retries(fn.apply(new Retries.Builder()).build());
        }

        public Builder requestsPerSecond(@Nullable Long value) {
            this.requestsPerSecond = value;
            return this;
        }

        public Builder sliceId(@Nullable Integer value) {
            this.sliceId = value;
            return this;
        }

        public Builder task(@Nullable String value) {
            this.task = value;
            return this;
        }

        public Builder throttledMillis(@Nullable String value) {
            this.throttledMillis = value;
            return this;
        }

        public Builder throttledUntilMillis(@Nullable String value) {
            this.throttledUntilMillis = value;
            return this;
        }

        public Builder timedOut(@Nullable Boolean value) {
            this.timedOut = value;
            return this;
        }

        public Builder took(@Nullable String value) {
            this.took = value;
            return this;
        }

        public Builder total(@Nullable Long value) {
            this.total = value;
            return this;
        }

        public Builder updated(@Nullable Long value) {
            this.updated = value;
            return this;
        }

        public Builder versionConflicts(@Nullable Long value) {
            this.versionConflicts = value;
            return this;
        }

        @Override
        public ReindexResponse build() {
            return new ReindexResponse(this);
        }
    }
}

