/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._core;

import co.elastic.clients.elasticsearch._core.rank_eval.RankEvalMetricDetail;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class RankEvalResponse
implements JsonpSerializable {
    private final double metricScore;
    private final Map<String, RankEvalMetricDetail> details;
    private final Map<String, JsonData> failures;
    public static final JsonpDeserializer<RankEvalResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RankEvalResponse::setupRankEvalResponseDeserializer, Builder::build);

    public RankEvalResponse(Builder builder) {
        this.metricScore = Objects.requireNonNull(builder.metricScore, "metric_score");
        this.details = ModelTypeHelper.unmodifiableNonNull(builder.details, "details");
        this.failures = ModelTypeHelper.unmodifiableNonNull(builder.failures, "failures");
    }

    public RankEvalResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public double metricScore() {
        return this.metricScore;
    }

    public Map<String, RankEvalMetricDetail> details() {
        return this.details;
    }

    public Map<String, JsonData> failures() {
        return this.failures;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("metric_score");
        generator.write(this.metricScore);
        generator.writeKey("details");
        generator.writeStartObject();
        for (Map.Entry<String, RankEvalMetricDetail> entry : this.details.entrySet()) {
            generator.writeKey(entry.getKey());
            entry.getValue().serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("failures");
        generator.writeStartObject();
        for (Map.Entry<String, JsonpSerializable> entry : this.failures.entrySet()) {
            generator.writeKey(entry.getKey());
            ((JsonData)entry.getValue()).serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupRankEvalResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::metricScore, JsonpDeserializer.doubleDeserializer(), "metric_score", new String[0]);
        op.add(Builder::details, JsonpDeserializer.stringMapDeserializer(RankEvalMetricDetail._DESERIALIZER), "details", new String[0]);
        op.add(Builder::failures, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "failures", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<RankEvalResponse> {
        private Double metricScore;
        private Map<String, RankEvalMetricDetail> details;
        private Map<String, JsonData> failures;

        public Builder metricScore(double value) {
            this.metricScore = value;
            return this;
        }

        public Builder details(Map<String, RankEvalMetricDetail> value) {
            this.details = value;
            return this;
        }

        public Builder putDetails(String key, RankEvalMetricDetail value) {
            if (this.details == null) {
                this.details = new HashMap<String, RankEvalMetricDetail>();
            }
            this.details.put(key, value);
            return this;
        }

        public Builder details(String key, Function<RankEvalMetricDetail.Builder, ObjectBuilder<RankEvalMetricDetail>> fn) {
            return this.details(Collections.singletonMap(key, fn.apply(new RankEvalMetricDetail.Builder()).build()));
        }

        public Builder putDetails(String key, Function<RankEvalMetricDetail.Builder, ObjectBuilder<RankEvalMetricDetail>> fn) {
            return this.putDetails(key, fn.apply(new RankEvalMetricDetail.Builder()).build());
        }

        public Builder failures(Map<String, JsonData> value) {
            this.failures = value;
            return this;
        }

        public Builder putFailures(String key, JsonData value) {
            if (this.failures == null) {
                this.failures = new HashMap<String, JsonData>();
            }
            this.failures.put(key, value);
            return this;
        }

        @Override
        public RankEvalResponse build() {
            return new RankEvalResponse(this);
        }
    }
}

