/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._core;

import co.elastic.clients.elasticsearch._types.StoredScript;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class GetScriptResponse
implements JsonpSerializable {
    private final String id;
    private final boolean found;
    @Nullable
    private final StoredScript script;
    public static final JsonpDeserializer<GetScriptResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetScriptResponse::setupGetScriptResponseDeserializer, Builder::build);

    public GetScriptResponse(Builder builder) {
        this.id = Objects.requireNonNull(builder.id, "_id");
        this.found = Objects.requireNonNull(builder.found, "found");
        this.script = builder.script;
    }

    public GetScriptResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String id() {
        return this.id;
    }

    public boolean found() {
        return this.found;
    }

    @Nullable
    public StoredScript script() {
        return this.script;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("_id");
        generator.write(this.id);
        generator.writeKey("found");
        generator.write(this.found);
        if (this.script != null) {
            generator.writeKey("script");
            this.script.serialize(generator, mapper);
        }
    }

    protected static void setupGetScriptResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "_id", new String[0]);
        op.add(Builder::found, JsonpDeserializer.booleanDeserializer(), "found", new String[0]);
        op.add(Builder::script, StoredScript._DESERIALIZER, "script", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<GetScriptResponse> {
        private String id;
        private Boolean found;
        @Nullable
        private StoredScript script;

        public Builder id(String value) {
            this.id = value;
            return this;
        }

        public Builder found(boolean value) {
            this.found = value;
            return this;
        }

        public Builder script(@Nullable StoredScript value) {
            this.script = value;
            return this;
        }

        public Builder script(Function<StoredScript.Builder, ObjectBuilder<StoredScript>> fn) {
            return this.script(fn.apply(new StoredScript.Builder()).build());
        }

        @Override
        public GetScriptResponse build() {
            return new GetScriptResponse(this);
        }
    }
}

