/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._core;

import co.elastic.clients.elasticsearch._core.bulk.ResponseItem;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class BulkResponse
implements JsonpSerializable {
    private final boolean errors;
    private final List<ResponseItem> items;
    private final long took;
    @Nullable
    private final Long ingestTook;
    public static final JsonpDeserializer<BulkResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, BulkResponse::setupBulkResponseDeserializer, Builder::build);

    public BulkResponse(Builder builder) {
        this.errors = Objects.requireNonNull(builder.errors, "errors");
        this.items = ModelTypeHelper.unmodifiableNonNull(builder.items, "items");
        this.took = Objects.requireNonNull(builder.took, "took");
        this.ingestTook = builder.ingestTook;
    }

    public BulkResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public boolean errors() {
        return this.errors;
    }

    public List<ResponseItem> items() {
        return this.items;
    }

    public long took() {
        return this.took;
    }

    @Nullable
    public Long ingestTook() {
        return this.ingestTook;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("errors");
        generator.write(this.errors);
        generator.writeKey("items");
        generator.writeStartArray();
        for (ResponseItem item0 : this.items) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("took");
        generator.write(this.took);
        if (this.ingestTook != null) {
            generator.writeKey("ingest_took");
            generator.write(this.ingestTook.longValue());
        }
    }

    protected static void setupBulkResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::errors, JsonpDeserializer.booleanDeserializer(), "errors", new String[0]);
        op.add(Builder::items, JsonpDeserializer.arrayDeserializer(ResponseItem._DESERIALIZER), "items", new String[0]);
        op.add(Builder::took, JsonpDeserializer.longDeserializer(), "took", new String[0]);
        op.add(Builder::ingestTook, JsonpDeserializer.longDeserializer(), "ingest_took", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<BulkResponse> {
        private Boolean errors;
        private List<ResponseItem> items;
        private Long took;
        @Nullable
        private Long ingestTook;

        public Builder errors(boolean value) {
            this.errors = value;
            return this;
        }

        public Builder items(List<ResponseItem> value) {
            this.items = value;
            return this;
        }

        public Builder items(ResponseItem ... value) {
            this.items = Arrays.asList(value);
            return this;
        }

        public Builder addItems(ResponseItem value) {
            if (this.items == null) {
                this.items = new ArrayList<ResponseItem>();
            }
            this.items.add(value);
            return this;
        }

        public Builder items(Function<ResponseItem.Builder, ObjectBuilder<ResponseItem>> fn) {
            return this.items(fn.apply(new ResponseItem.Builder()).build());
        }

        public Builder addItems(Function<ResponseItem.Builder, ObjectBuilder<ResponseItem>> fn) {
            return this.addItems(fn.apply(new ResponseItem.Builder()).build());
        }

        public Builder took(long value) {
            this.took = value;
            return this;
        }

        public Builder ingestTook(@Nullable Long value) {
            this.ingestTook = value;
            return this;
        }

        @Override
        public BulkResponse build() {
            return new BulkResponse(this);
        }
    }
}

