/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.json;

import co.elastic.clients.json.BuildFunctionDeserializer;
import co.elastic.clients.json.BuildFunctionInstanceDeserializer;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.InstanceDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.TriFunction;
import jakarta.json.JsonNumber;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonParser;
import jakarta.json.stream.JsonParsingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public abstract class JsonpDeserializer<V> {
    private final EnumSet<JsonParser.Event> acceptedEvents;
    private static final JsonpDeserializer<String> STRING = new JsonpDeserializer<String>(EnumSet.of(JsonParser.Event.VALUE_STRING, JsonParser.Event.VALUE_NUMBER, JsonParser.Event.VALUE_FALSE, JsonParser.Event.VALUE_TRUE)){

        @Override
        public String deserialize(JsonParser parser, JsonpMapper mapper, JsonParser.Event event) {
            if (event == JsonParser.Event.VALUE_TRUE) {
                return "true";
            }
            if (event == JsonParser.Event.VALUE_FALSE) {
                return "false";
            }
            return parser.getString();
        }
    };
    private static final JsonpDeserializer<Integer> INTEGER = new JsonpDeserializer<Integer>(EnumSet.of(JsonParser.Event.VALUE_NUMBER, JsonParser.Event.VALUE_STRING)){

        @Override
        public Integer deserialize(JsonParser parser, JsonpMapper mapper, JsonParser.Event event) {
            if (event == JsonParser.Event.VALUE_STRING) {
                return Integer.valueOf(parser.getString());
            }
            return parser.getInt();
        }
    };
    private static final JsonpDeserializer<Boolean> BOOLEAN = new JsonpDeserializer<Boolean>(EnumSet.of(JsonParser.Event.VALUE_FALSE, JsonParser.Event.VALUE_TRUE)){

        @Override
        public Boolean deserialize(JsonParser parser, JsonpMapper mapper, JsonParser.Event event) {
            return event == JsonParser.Event.VALUE_TRUE;
        }
    };
    private static final JsonpDeserializer<Long> LONG = new JsonpDeserializer<Long>(EnumSet.of(JsonParser.Event.VALUE_NUMBER, JsonParser.Event.VALUE_STRING)){

        @Override
        public Long deserialize(JsonParser parser, JsonpMapper mapper, JsonParser.Event event) {
            if (event == JsonParser.Event.VALUE_STRING) {
                return Long.valueOf(parser.getString());
            }
            return parser.getLong();
        }
    };
    private static final JsonpDeserializer<Float> FLOAT = new JsonpDeserializer<Float>(EnumSet.of(JsonParser.Event.VALUE_NUMBER, JsonParser.Event.VALUE_STRING)){

        @Override
        public Float deserialize(JsonParser parser, JsonpMapper mapper, JsonParser.Event event) {
            if (event == JsonParser.Event.VALUE_STRING) {
                return Float.valueOf(parser.getString());
            }
            return Float.valueOf(((JsonNumber)parser.getValue()).numberValue().floatValue());
        }
    };
    private static final JsonpDeserializer<Double> DOUBLE = new JsonpDeserializer<Double>(EnumSet.of(JsonParser.Event.VALUE_NUMBER, JsonParser.Event.VALUE_STRING)){

        @Override
        public Double deserialize(JsonParser parser, JsonpMapper mapper, JsonParser.Event event) {
            if (event == JsonParser.Event.VALUE_STRING) {
                return Double.valueOf(parser.getString());
            }
            return ((JsonNumber)parser.getValue()).doubleValue();
        }
    };
    private static final JsonpDeserializer<Number> NUMBER = new JsonpDeserializer<Number>(EnumSet.of(JsonParser.Event.VALUE_NUMBER, JsonParser.Event.VALUE_STRING)){

        @Override
        public Number deserialize(JsonParser parser, JsonpMapper mapper, JsonParser.Event event) {
            if (event == JsonParser.Event.VALUE_STRING) {
                return Double.valueOf(parser.getString());
            }
            return ((JsonNumber)parser.getValue()).numberValue();
        }
    };
    private static final JsonpDeserializer<JsonValue> JSON_VALUE = new JsonpDeserializer<JsonValue>(EnumSet.allOf(JsonParser.Event.class)){

        @Override
        public JsonValue deserialize(JsonParser parser, JsonpMapper mapper, JsonParser.Event event) {
            return parser.getValue();
        }
    };

    protected JsonpDeserializer(EnumSet<JsonParser.Event> acceptedEvents) {
        this.acceptedEvents = acceptedEvents;
    }

    protected static EnumSet<JsonParser.Event> allAcceptedEvents(JsonpDeserializer<?> ... deserializers) {
        EnumSet<JsonParser.Event> result = EnumSet.noneOf(JsonParser.Event.class);
        for (JsonpDeserializer<?> deserializer : deserializers) {
            EnumSet<JsonParser.Event> set = deserializer.acceptedEvents();
            result.addAll(set);
        }
        return result;
    }

    public final EnumSet<JsonParser.Event> acceptedEvents() {
        return this.acceptedEvents;
    }

    public final boolean accepts(JsonParser.Event event) {
        return this.acceptedEvents.contains(event);
    }

    protected final void ensureAccepts(JsonParser parser, JsonParser.Event event) {
        if (!this.acceptedEvents.contains(event)) {
            throw new JsonParsingException(String.format("Unexpected JSON event '%s', expected %s", event, this.acceptedEvents.toString()), parser.getLocation());
        }
    }

    public V deserialize(JsonParser parser, JsonpMapper mapper) {
        JsonParser.Event event = parser.next();
        if (event == JsonParser.Event.VALUE_NULL) {
            return null;
        }
        this.ensureAccepts(parser, event);
        return this.deserialize(parser, mapper, event);
    }

    public abstract V deserialize(JsonParser var1, JsonpMapper var2, JsonParser.Event var3);

    public static <T> JsonpDeserializer<T> of(final Class<T> clazz) {
        return new JsonpDeserializer<T>(EnumSet.allOf(JsonParser.Event.class)){

            @Override
            public T deserialize(JsonParser parser, JsonpMapper mapper) {
                return mapper.deserialize(parser, clazz);
            }

            @Override
            public T deserialize(JsonParser parser, JsonpMapper mapper, JsonParser.Event event) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <T> JsonpDeserializer<T> of(EnumSet<JsonParser.Event> acceptedEvents, final TriFunction<JsonParser, JsonpMapper, JsonParser.Event, T> fn) {
        return new JsonpDeserializer<T>(acceptedEvents){

            @Override
            public T deserialize(JsonParser parser, JsonpMapper mapper, JsonParser.Event event) {
                return fn.apply(parser, mapper, event);
            }
        };
    }

    public static <T> JsonpDeserializer<T> of(EnumSet<JsonParser.Event> acceptedEvents, final BiFunction<JsonParser, JsonpMapper, T> fn) {
        return new JsonpDeserializer<T>(acceptedEvents){

            @Override
            public T deserialize(JsonParser parser, JsonpMapper mapper) {
                return fn.apply(parser, mapper);
            }

            @Override
            public T deserialize(JsonParser parser, JsonpMapper mapper, JsonParser.Event event) {
                throw new UnsupportedOperationException("Should not reach this point");
            }
        };
    }

    public static <T> JsonpDeserializer<T> lazy(Supplier<JsonpDeserializer<T>> builder) {
        return new LazyDeserializer(builder, EnumSet.of(JsonParser.Event.START_OBJECT));
    }

    public static <T> JsonpDeserializer<T> lazy(Supplier<JsonpDeserializer<T>> builder, EnumSet<JsonParser.Event> acceptedEvents) {
        return new LazyDeserializer(builder, acceptedEvents);
    }

    public static <B, T> JsonpDeserializer<T> lazy(Supplier<B> builderCtor, Consumer<DelegatingDeserializer<B>> builderSetup, Function<B, T> buildFn) {
        return JsonpDeserializer.lazy(() -> {
            ObjectDeserializer builderDeser = new ObjectDeserializer(builderCtor);
            builderSetup.accept(builderDeser);
            return new BuildFunctionDeserializer(builderDeser, buildFn);
        });
    }

    public static <B, T> InstanceDeserializer<B, ObjectBuilder<T>> lazyInstance(Supplier<B> builderCtor, Consumer<DelegatingDeserializer<B>> builderSetup, Function<B, T> buildFn) {
        return new LazyInstanceDeserializer(() -> {
            ObjectDeserializer builderDeser = new ObjectDeserializer(builderCtor);
            builderSetup.accept(builderDeser);
            return new BuildFunctionInstanceDeserializer(builderDeser, buildFn);
        });
    }

    public static <T> JsonpDeserializer<T> fixedValue(final T value) {
        return new JsonpDeserializer<T>(EnumSet.noneOf(JsonParser.Event.class)){

            @Override
            public T deserialize(JsonParser parser, JsonpMapper mapper, JsonParser.Event event) {
                return value;
            }
        };
    }

    public static <T> JsonpDeserializer<T> emptyObject(final T value) {
        return new JsonpDeserializer<T>(EnumSet.of(JsonParser.Event.START_OBJECT)){

            @Override
            public T deserialize(JsonParser parser, JsonpMapper mapper, JsonParser.Event event) {
                if (event == JsonParser.Event.VALUE_NULL) {
                    return null;
                }
                JsonpUtils.expectNextEvent(parser, JsonParser.Event.END_OBJECT);
                return value;
            }
        };
    }

    public static JsonpDeserializer<String> stringDeserializer() {
        return STRING;
    }

    public static JsonpDeserializer<Integer> integerDeserializer() {
        return INTEGER;
    }

    public static JsonpDeserializer<Boolean> booleanDeserializer() {
        return BOOLEAN;
    }

    public static JsonpDeserializer<Long> longDeserializer() {
        return LONG;
    }

    public static JsonpDeserializer<Float> floatDeserializer() {
        return FLOAT;
    }

    public static JsonpDeserializer<Double> doubleDeserializer() {
        return DOUBLE;
    }

    public static JsonpDeserializer<Number> numberDeserializer() {
        return NUMBER;
    }

    public static JsonpDeserializer<JsonValue> jsonValueDeserializer() {
        return JSON_VALUE;
    }

    public static <T> JsonpDeserializer<List<T>> arrayDeserializer(JsonpDeserializer<T> itemDeserializer) {
        return new ArrayDeserializer<T>(itemDeserializer);
    }

    public static <T> JsonpDeserializer<Map<String, T>> stringMapDeserializer(JsonpDeserializer<T> itemDeserializer) {
        return new StringMapDeserializer<T>(itemDeserializer);
    }

    private static class LazyDeserializer<T>
    extends JsonpDeserializer<T> {
        private final Supplier<JsonpDeserializer<T>> builder;
        private volatile JsonpDeserializer<T> deserializer = null;

        private LazyDeserializer(Supplier<JsonpDeserializer<T>> builder, EnumSet<JsonParser.Event> acceptedEvents) {
            super(acceptedEvents);
            this.builder = builder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T deserialize(JsonParser parser, JsonpMapper mapper, JsonParser.Event event) {
            JsonpDeserializer<T> d = this.deserializer;
            if (d == null) {
                LazyDeserializer lazyDeserializer = this;
                synchronized (lazyDeserializer) {
                    if (this.deserializer == null) {
                        d = this.builder.get();
                        this.deserializer = d;
                    }
                }
            }
            return d.deserialize(parser, mapper, event);
        }
    }

    private static class LazyInstanceDeserializer<B, T>
    implements InstanceDeserializer<B, T> {
        private final Supplier<InstanceDeserializer<B, T>> ctor;
        private volatile InstanceDeserializer<B, T> deserializer = null;

        private LazyInstanceDeserializer(Supplier<InstanceDeserializer<B, T>> ctor) {
            this.ctor = ctor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T deserialize(B instance, JsonParser parser, JsonpMapper mapper, JsonParser.Event event) {
            InstanceDeserializer<B, T> d = this.deserializer;
            if (d == null) {
                LazyInstanceDeserializer lazyInstanceDeserializer = this;
                synchronized (lazyInstanceDeserializer) {
                    if (this.deserializer == null) {
                        d = this.ctor.get();
                        this.deserializer = d;
                    }
                }
            }
            return d.deserialize(instance, parser, mapper, event);
        }
    }

    private static class ArrayDeserializer<T>
    extends JsonpDeserializer<List<T>> {
        private final JsonpDeserializer<T> itemDeserializer;

        private static <T> EnumSet<JsonParser.Event> lenientEvents(JsonpDeserializer<T> itemDeserializer) {
            EnumSet<JsonParser.Event> set = EnumSet.of(JsonParser.Event.START_ARRAY);
            set.addAll(itemDeserializer.acceptedEvents());
            return set;
        }

        protected ArrayDeserializer(JsonpDeserializer<T> itemDeserializer) {
            super(ArrayDeserializer.lenientEvents(itemDeserializer));
            this.itemDeserializer = itemDeserializer;
        }

        @Override
        public List<T> deserialize(JsonParser parser, JsonpMapper mapper, JsonParser.Event event) {
            if (event == JsonParser.Event.START_ARRAY) {
                ArrayList<T> result = new ArrayList<T>();
                while ((event = parser.next()) != JsonParser.Event.END_ARRAY) {
                    this.itemDeserializer.ensureAccepts(parser, event);
                    result.add(this.itemDeserializer.deserialize(parser, mapper, event));
                }
                return result;
            }
            this.itemDeserializer.ensureAccepts(parser, event);
            return Collections.singletonList(this.itemDeserializer.deserialize(parser, mapper, event));
        }
    }

    private static class StringMapDeserializer<T>
    extends JsonpDeserializer<Map<String, T>> {
        private final JsonpDeserializer<T> itemDeserializer;

        protected StringMapDeserializer(JsonpDeserializer<T> itemDeserializer) {
            super(EnumSet.of(JsonParser.Event.START_OBJECT));
            this.itemDeserializer = itemDeserializer;
        }

        @Override
        public Map<String, T> deserialize(JsonParser parser, JsonpMapper mapper, JsonParser.Event event) {
            HashMap<String, T> result = new HashMap<String, T>();
            while ((event = parser.next()) != JsonParser.Event.END_OBJECT) {
                JsonpUtils.expectEvent(parser, JsonParser.Event.KEY_NAME, event);
                String key = parser.getString();
                T value = this.itemDeserializer.deserialize(parser, mapper);
                result.put(key, value);
            }
            return result;
        }
    }
}

