/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.usage;

import co.elastic.clients.elasticsearch.xpack.usage.MlCounter;
import co.elastic.clients.elasticsearch.xpack.usage.MlInferenceIngestProcessorCount;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class MlInferenceIngestProcessor
implements JsonpSerializable {
    private final MlInferenceIngestProcessorCount numDocsProcessed;
    private final MlCounter pipelines;
    private final MlInferenceIngestProcessorCount numFailures;
    private final MlInferenceIngestProcessorCount timeMs;
    public static final JsonpDeserializer<MlInferenceIngestProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MlInferenceIngestProcessor::setupMlInferenceIngestProcessorDeserializer, Builder::build);

    public MlInferenceIngestProcessor(Builder builder) {
        this.numDocsProcessed = Objects.requireNonNull(builder.numDocsProcessed, "num_docs_processed");
        this.pipelines = Objects.requireNonNull(builder.pipelines, "pipelines");
        this.numFailures = Objects.requireNonNull(builder.numFailures, "num_failures");
        this.timeMs = Objects.requireNonNull(builder.timeMs, "time_ms");
    }

    public MlInferenceIngestProcessor(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public MlInferenceIngestProcessorCount numDocsProcessed() {
        return this.numDocsProcessed;
    }

    public MlCounter pipelines() {
        return this.pipelines;
    }

    public MlInferenceIngestProcessorCount numFailures() {
        return this.numFailures;
    }

    public MlInferenceIngestProcessorCount timeMs() {
        return this.timeMs;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("num_docs_processed");
        this.numDocsProcessed.serialize(generator, mapper);
        generator.writeKey("pipelines");
        this.pipelines.serialize(generator, mapper);
        generator.writeKey("num_failures");
        this.numFailures.serialize(generator, mapper);
        generator.writeKey("time_ms");
        this.timeMs.serialize(generator, mapper);
    }

    protected static void setupMlInferenceIngestProcessorDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::numDocsProcessed, MlInferenceIngestProcessorCount._DESERIALIZER, "num_docs_processed", new String[0]);
        op.add(Builder::pipelines, MlCounter._DESERIALIZER, "pipelines", new String[0]);
        op.add(Builder::numFailures, MlInferenceIngestProcessorCount._DESERIALIZER, "num_failures", new String[0]);
        op.add(Builder::timeMs, MlInferenceIngestProcessorCount._DESERIALIZER, "time_ms", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<MlInferenceIngestProcessor> {
        private MlInferenceIngestProcessorCount numDocsProcessed;
        private MlCounter pipelines;
        private MlInferenceIngestProcessorCount numFailures;
        private MlInferenceIngestProcessorCount timeMs;

        public Builder numDocsProcessed(MlInferenceIngestProcessorCount value) {
            this.numDocsProcessed = value;
            return this;
        }

        public Builder numDocsProcessed(Function<MlInferenceIngestProcessorCount.Builder, ObjectBuilder<MlInferenceIngestProcessorCount>> fn) {
            return this.numDocsProcessed(fn.apply(new MlInferenceIngestProcessorCount.Builder()).build());
        }

        public Builder pipelines(MlCounter value) {
            this.pipelines = value;
            return this;
        }

        public Builder pipelines(Function<MlCounter.Builder, ObjectBuilder<MlCounter>> fn) {
            return this.pipelines(fn.apply(new MlCounter.Builder()).build());
        }

        public Builder numFailures(MlInferenceIngestProcessorCount value) {
            this.numFailures = value;
            return this;
        }

        public Builder numFailures(Function<MlInferenceIngestProcessorCount.Builder, ObjectBuilder<MlInferenceIngestProcessorCount>> fn) {
            return this.numFailures(fn.apply(new MlInferenceIngestProcessorCount.Builder()).build());
        }

        public Builder timeMs(MlInferenceIngestProcessorCount value) {
            this.timeMs = value;
            return this;
        }

        public Builder timeMs(Function<MlInferenceIngestProcessorCount.Builder, ObjectBuilder<MlInferenceIngestProcessorCount>> fn) {
            return this.timeMs(fn.apply(new MlInferenceIngestProcessorCount.Builder()).build());
        }

        @Override
        public MlInferenceIngestProcessor build() {
            return new MlInferenceIngestProcessor(this);
        }
    }
}

