/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.usage;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class EqlFeaturesKeys
implements JsonpSerializable {
    private final Number joinKeysTwo;
    private final Number joinKeysOne;
    private final Number joinKeysThree;
    private final Number joinKeysFiveOrMore;
    private final Number joinKeysFour;
    public static final JsonpDeserializer<EqlFeaturesKeys> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, EqlFeaturesKeys::setupEqlFeaturesKeysDeserializer, Builder::build);

    public EqlFeaturesKeys(Builder builder) {
        this.joinKeysTwo = Objects.requireNonNull(builder.joinKeysTwo, "join_keys_two");
        this.joinKeysOne = Objects.requireNonNull(builder.joinKeysOne, "join_keys_one");
        this.joinKeysThree = Objects.requireNonNull(builder.joinKeysThree, "join_keys_three");
        this.joinKeysFiveOrMore = Objects.requireNonNull(builder.joinKeysFiveOrMore, "join_keys_five_or_more");
        this.joinKeysFour = Objects.requireNonNull(builder.joinKeysFour, "join_keys_four");
    }

    public EqlFeaturesKeys(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public Number joinKeysTwo() {
        return this.joinKeysTwo;
    }

    public Number joinKeysOne() {
        return this.joinKeysOne;
    }

    public Number joinKeysThree() {
        return this.joinKeysThree;
    }

    public Number joinKeysFiveOrMore() {
        return this.joinKeysFiveOrMore;
    }

    public Number joinKeysFour() {
        return this.joinKeysFour;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("join_keys_two");
        generator.write(this.joinKeysTwo.doubleValue());
        generator.writeKey("join_keys_one");
        generator.write(this.joinKeysOne.doubleValue());
        generator.writeKey("join_keys_three");
        generator.write(this.joinKeysThree.doubleValue());
        generator.writeKey("join_keys_five_or_more");
        generator.write(this.joinKeysFiveOrMore.doubleValue());
        generator.writeKey("join_keys_four");
        generator.write(this.joinKeysFour.doubleValue());
    }

    protected static void setupEqlFeaturesKeysDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::joinKeysTwo, JsonpDeserializer.numberDeserializer(), "join_keys_two", new String[0]);
        op.add(Builder::joinKeysOne, JsonpDeserializer.numberDeserializer(), "join_keys_one", new String[0]);
        op.add(Builder::joinKeysThree, JsonpDeserializer.numberDeserializer(), "join_keys_three", new String[0]);
        op.add(Builder::joinKeysFiveOrMore, JsonpDeserializer.numberDeserializer(), "join_keys_five_or_more", new String[0]);
        op.add(Builder::joinKeysFour, JsonpDeserializer.numberDeserializer(), "join_keys_four", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<EqlFeaturesKeys> {
        private Number joinKeysTwo;
        private Number joinKeysOne;
        private Number joinKeysThree;
        private Number joinKeysFiveOrMore;
        private Number joinKeysFour;

        public Builder joinKeysTwo(Number value) {
            this.joinKeysTwo = value;
            return this;
        }

        public Builder joinKeysOne(Number value) {
            this.joinKeysOne = value;
            return this;
        }

        public Builder joinKeysThree(Number value) {
            this.joinKeysThree = value;
            return this;
        }

        public Builder joinKeysFiveOrMore(Number value) {
            this.joinKeysFiveOrMore = value;
            return this;
        }

        public Builder joinKeysFour(Number value) {
            this.joinKeysFour = value;
            return this;
        }

        @Override
        public EqlFeaturesKeys build() {
            return new EqlFeaturesKeys(this);
        }
    }
}

