/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.usage;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class EqlFeaturesJoin
implements JsonpSerializable {
    private final Number joinQueriesTwo;
    private final Number joinQueriesThree;
    private final Number joinUntil;
    private final Number joinQueriesFiveOrMore;
    private final Number joinQueriesFour;
    public static final JsonpDeserializer<EqlFeaturesJoin> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, EqlFeaturesJoin::setupEqlFeaturesJoinDeserializer, Builder::build);

    public EqlFeaturesJoin(Builder builder) {
        this.joinQueriesTwo = Objects.requireNonNull(builder.joinQueriesTwo, "join_queries_two");
        this.joinQueriesThree = Objects.requireNonNull(builder.joinQueriesThree, "join_queries_three");
        this.joinUntil = Objects.requireNonNull(builder.joinUntil, "join_until");
        this.joinQueriesFiveOrMore = Objects.requireNonNull(builder.joinQueriesFiveOrMore, "join_queries_five_or_more");
        this.joinQueriesFour = Objects.requireNonNull(builder.joinQueriesFour, "join_queries_four");
    }

    public EqlFeaturesJoin(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public Number joinQueriesTwo() {
        return this.joinQueriesTwo;
    }

    public Number joinQueriesThree() {
        return this.joinQueriesThree;
    }

    public Number joinUntil() {
        return this.joinUntil;
    }

    public Number joinQueriesFiveOrMore() {
        return this.joinQueriesFiveOrMore;
    }

    public Number joinQueriesFour() {
        return this.joinQueriesFour;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("join_queries_two");
        generator.write(this.joinQueriesTwo.doubleValue());
        generator.writeKey("join_queries_three");
        generator.write(this.joinQueriesThree.doubleValue());
        generator.writeKey("join_until");
        generator.write(this.joinUntil.doubleValue());
        generator.writeKey("join_queries_five_or_more");
        generator.write(this.joinQueriesFiveOrMore.doubleValue());
        generator.writeKey("join_queries_four");
        generator.write(this.joinQueriesFour.doubleValue());
    }

    protected static void setupEqlFeaturesJoinDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::joinQueriesTwo, JsonpDeserializer.numberDeserializer(), "join_queries_two", new String[0]);
        op.add(Builder::joinQueriesThree, JsonpDeserializer.numberDeserializer(), "join_queries_three", new String[0]);
        op.add(Builder::joinUntil, JsonpDeserializer.numberDeserializer(), "join_until", new String[0]);
        op.add(Builder::joinQueriesFiveOrMore, JsonpDeserializer.numberDeserializer(), "join_queries_five_or_more", new String[0]);
        op.add(Builder::joinQueriesFour, JsonpDeserializer.numberDeserializer(), "join_queries_four", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<EqlFeaturesJoin> {
        private Number joinQueriesTwo;
        private Number joinQueriesThree;
        private Number joinUntil;
        private Number joinQueriesFiveOrMore;
        private Number joinQueriesFour;

        public Builder joinQueriesTwo(Number value) {
            this.joinQueriesTwo = value;
            return this;
        }

        public Builder joinQueriesThree(Number value) {
            this.joinQueriesThree = value;
            return this;
        }

        public Builder joinUntil(Number value) {
            this.joinUntil = value;
            return this;
        }

        public Builder joinQueriesFiveOrMore(Number value) {
            this.joinQueriesFiveOrMore = value;
            return this;
        }

        public Builder joinQueriesFour(Number value) {
            this.joinQueriesFour = value;
            return this;
        }

        @Override
        public EqlFeaturesJoin build() {
            return new EqlFeaturesJoin(this);
        }
    }
}

