/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.usage;

import co.elastic.clients.elasticsearch.xpack.usage.Base;
import co.elastic.clients.elasticsearch.xpack.usage.EqlFeatures;
import co.elastic.clients.elasticsearch.xpack.usage.Query;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class Eql
extends Base {
    private final EqlFeatures features;
    private final Map<String, Query> queries;
    public static final JsonpDeserializer<Eql> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Eql::setupEqlDeserializer, Builder::build);

    public Eql(Builder builder) {
        super(builder);
        this.features = Objects.requireNonNull(builder.features, "features");
        this.queries = ModelTypeHelper.unmodifiableNonNull(builder.queries, "queries");
    }

    public Eql(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public EqlFeatures features() {
        return this.features;
    }

    public Map<String, Query> queries() {
        return this.queries;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("features");
        this.features.serialize(generator, mapper);
        generator.writeKey("queries");
        generator.writeStartObject();
        for (Map.Entry<String, Query> item0 : this.queries.entrySet()) {
            generator.writeKey(item0.getKey());
            item0.getValue().serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupEqlDeserializer(DelegatingDeserializer<Builder> op) {
        Base.setupBaseDeserializer(op);
        op.add(Builder::features, EqlFeatures._DESERIALIZER, "features", new String[0]);
        op.add(Builder::queries, JsonpDeserializer.stringMapDeserializer(Query._DESERIALIZER), "queries", new String[0]);
    }

    public static class Builder
    extends Base.AbstractBuilder<Builder>
    implements ObjectBuilder<Eql> {
        private EqlFeatures features;
        private Map<String, Query> queries;

        public Builder features(EqlFeatures value) {
            this.features = value;
            return this;
        }

        public Builder features(Function<EqlFeatures.Builder, ObjectBuilder<EqlFeatures>> fn) {
            return this.features(fn.apply(new EqlFeatures.Builder()).build());
        }

        public Builder queries(Map<String, Query> value) {
            this.queries = value;
            return this;
        }

        public Builder putQueries(String key, Query value) {
            if (this.queries == null) {
                this.queries = new HashMap<String, Query>();
            }
            this.queries.put(key, value);
            return this;
        }

        public Builder queries(String key, Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.queries(Collections.singletonMap(key, fn.apply(new Query.Builder()).build()));
        }

        public Builder putQueries(String key, Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.putQueries(key, fn.apply(new Query.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Eql build() {
            return new Eql(this);
        }
    }
}

