/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class SimulatedActions
implements JsonpSerializable {
    private final List<String> actions;
    private final SimulatedActions all;
    private final boolean useAll;
    public static final JsonpDeserializer<SimulatedActions> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SimulatedActions::setupSimulatedActionsDeserializer, Builder::build);

    public SimulatedActions(Builder builder) {
        this.actions = ModelTypeHelper.unmodifiableNonNull(builder.actions, "actions");
        this.all = Objects.requireNonNull(builder.all, "all");
        this.useAll = Objects.requireNonNull(builder.useAll, "use_all");
    }

    public SimulatedActions(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<String> actions() {
        return this.actions;
    }

    public SimulatedActions all() {
        return this.all;
    }

    public boolean useAll() {
        return this.useAll;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("actions");
        generator.writeStartArray();
        for (String item0 : this.actions) {
            generator.write(item0);
        }
        generator.writeEnd();
        generator.writeKey("all");
        this.all.serialize(generator, mapper);
        generator.writeKey("use_all");
        generator.write(this.useAll);
    }

    protected static void setupSimulatedActionsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::actions, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "actions", new String[0]);
        op.add(Builder::all, _DESERIALIZER, "all", new String[0]);
        op.add(Builder::useAll, JsonpDeserializer.booleanDeserializer(), "use_all", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<SimulatedActions> {
        private List<String> actions;
        private SimulatedActions all;
        private Boolean useAll;

        public Builder actions(List<String> value) {
            this.actions = value;
            return this;
        }

        public Builder actions(String ... value) {
            this.actions = Arrays.asList(value);
            return this;
        }

        public Builder addActions(String value) {
            if (this.actions == null) {
                this.actions = new ArrayList<String>();
            }
            this.actions.add(value);
            return this;
        }

        public Builder all(SimulatedActions value) {
            this.all = value;
            return this;
        }

        public Builder all(Function<Builder, ObjectBuilder<SimulatedActions>> fn) {
            return this.all(fn.apply(new Builder()).build());
        }

        public Builder useAll(boolean value) {
            this.useAll = value;
            return this;
        }

        @Override
        public SimulatedActions build() {
            return new SimulatedActions(this);
        }
    }
}

