/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.elasticsearch.watcher.QueryWatch;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class QueryWatchesResponse
implements JsonpSerializable {
    private final int count;
    private final List<QueryWatch> watches;
    public static final JsonpDeserializer<QueryWatchesResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, QueryWatchesResponse::setupQueryWatchesResponseDeserializer, Builder::build);

    public QueryWatchesResponse(Builder builder) {
        this.count = Objects.requireNonNull(builder.count, "count");
        this.watches = ModelTypeHelper.unmodifiableNonNull(builder.watches, "watches");
    }

    public QueryWatchesResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public int count() {
        return this.count;
    }

    public List<QueryWatch> watches() {
        return this.watches;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("count");
        generator.write(this.count);
        generator.writeKey("watches");
        generator.writeStartArray();
        for (QueryWatch item0 : this.watches) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupQueryWatchesResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::count, JsonpDeserializer.integerDeserializer(), "count", new String[0]);
        op.add(Builder::watches, JsonpDeserializer.arrayDeserializer(QueryWatch._DESERIALIZER), "watches", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<QueryWatchesResponse> {
        private Integer count;
        private List<QueryWatch> watches;

        public Builder count(int value) {
            this.count = value;
            return this;
        }

        public Builder watches(List<QueryWatch> value) {
            this.watches = value;
            return this;
        }

        public Builder watches(QueryWatch ... value) {
            this.watches = Arrays.asList(value);
            return this;
        }

        public Builder addWatches(QueryWatch value) {
            if (this.watches == null) {
                this.watches = new ArrayList<QueryWatch>();
            }
            this.watches.add(value);
            return this;
        }

        public Builder watches(Function<QueryWatch.Builder, ObjectBuilder<QueryWatch>> fn) {
            return this.watches(fn.apply(new QueryWatch.Builder()).build());
        }

        public Builder addWatches(Function<QueryWatch.Builder, ObjectBuilder<QueryWatch>> fn) {
            return this.addWatches(fn.apply(new QueryWatch.Builder()).build());
        }

        @Override
        public QueryWatchesResponse build() {
            return new QueryWatchesResponse(this);
        }
    }
}

