/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.elasticsearch.watcher.ConnectionScheme;
import co.elastic.clients.elasticsearch.watcher.HttpInputAuthentication;
import co.elastic.clients.elasticsearch.watcher.HttpInputMethod;
import co.elastic.clients.elasticsearch.watcher.HttpInputProxy;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class HttpInputRequestDefinition
implements JsonpSerializable {
    @Nullable
    private final HttpInputAuthentication auth;
    @Nullable
    private final String body;
    @Nullable
    private final String connectionTimeout;
    @Nullable
    private final Map<String, String> headers;
    @Nullable
    private final String host;
    @Nullable
    private final HttpInputMethod method;
    @Nullable
    private final Map<String, String> params;
    @Nullable
    private final String path;
    @Nullable
    private final Number port;
    @Nullable
    private final HttpInputProxy proxy;
    @Nullable
    private final String readTimeout;
    @Nullable
    private final ConnectionScheme scheme;
    @Nullable
    private final String url;
    public static final JsonpDeserializer<HttpInputRequestDefinition> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, HttpInputRequestDefinition::setupHttpInputRequestDefinitionDeserializer, Builder::build);

    public HttpInputRequestDefinition(AbstractBuilder<?> builder) {
        this.auth = ((AbstractBuilder)builder).auth;
        this.body = ((AbstractBuilder)builder).body;
        this.connectionTimeout = ((AbstractBuilder)builder).connectionTimeout;
        this.headers = ModelTypeHelper.unmodifiable(((AbstractBuilder)builder).headers);
        this.host = ((AbstractBuilder)builder).host;
        this.method = ((AbstractBuilder)builder).method;
        this.params = ModelTypeHelper.unmodifiable(((AbstractBuilder)builder).params);
        this.path = ((AbstractBuilder)builder).path;
        this.port = ((AbstractBuilder)builder).port;
        this.proxy = ((AbstractBuilder)builder).proxy;
        this.readTimeout = ((AbstractBuilder)builder).readTimeout;
        this.scheme = ((AbstractBuilder)builder).scheme;
        this.url = ((AbstractBuilder)builder).url;
    }

    @Nullable
    public HttpInputAuthentication auth() {
        return this.auth;
    }

    @Nullable
    public String body() {
        return this.body;
    }

    @Nullable
    public String connectionTimeout() {
        return this.connectionTimeout;
    }

    @Nullable
    public Map<String, String> headers() {
        return this.headers;
    }

    @Nullable
    public String host() {
        return this.host;
    }

    @Nullable
    public HttpInputMethod method() {
        return this.method;
    }

    @Nullable
    public Map<String, String> params() {
        return this.params;
    }

    @Nullable
    public String path() {
        return this.path;
    }

    @Nullable
    public Number port() {
        return this.port;
    }

    @Nullable
    public HttpInputProxy proxy() {
        return this.proxy;
    }

    @Nullable
    public String readTimeout() {
        return this.readTimeout;
    }

    @Nullable
    public ConnectionScheme scheme() {
        return this.scheme;
    }

    @Nullable
    public String url() {
        return this.url;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.auth != null) {
            generator.writeKey("auth");
            this.auth.serialize(generator, mapper);
        }
        if (this.body != null) {
            generator.writeKey("body");
            generator.write(this.body);
        }
        if (this.connectionTimeout != null) {
            generator.writeKey("connection_timeout");
            generator.write(this.connectionTimeout);
        }
        if (this.headers != null) {
            generator.writeKey("headers");
            generator.writeStartObject();
            for (Map.Entry<String, String> item0 : this.headers.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.write(item0.getValue());
            }
            generator.writeEnd();
        }
        if (this.host != null) {
            generator.writeKey("host");
            generator.write(this.host);
        }
        if (this.method != null) {
            generator.writeKey("method");
            this.method.serialize(generator, mapper);
        }
        if (this.params != null) {
            generator.writeKey("params");
            generator.writeStartObject();
            for (Map.Entry<String, String> item0 : this.params.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.write(item0.getValue());
            }
            generator.writeEnd();
        }
        if (this.path != null) {
            generator.writeKey("path");
            generator.write(this.path);
        }
        if (this.port != null) {
            generator.writeKey("port");
            generator.write(this.port.doubleValue());
        }
        if (this.proxy != null) {
            generator.writeKey("proxy");
            this.proxy.serialize(generator, mapper);
        }
        if (this.readTimeout != null) {
            generator.writeKey("read_timeout");
            generator.write(this.readTimeout);
        }
        if (this.scheme != null) {
            generator.writeKey("scheme");
            this.scheme.serialize(generator, mapper);
        }
        if (this.url != null) {
            generator.writeKey("url");
            generator.write(this.url);
        }
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupHttpInputRequestDefinitionDeserializer(DelegatingDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::auth, HttpInputAuthentication._DESERIALIZER, "auth", new String[0]);
        op.add(AbstractBuilder::body, JsonpDeserializer.stringDeserializer(), "body", new String[0]);
        op.add(AbstractBuilder::connectionTimeout, JsonpDeserializer.stringDeserializer(), "connection_timeout", new String[0]);
        op.add(AbstractBuilder::headers, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "headers", new String[0]);
        op.add(AbstractBuilder::host, JsonpDeserializer.stringDeserializer(), "host", new String[0]);
        op.add(AbstractBuilder::method, HttpInputMethod._DESERIALIZER, "method", new String[0]);
        op.add(AbstractBuilder::params, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "params", new String[0]);
        op.add(AbstractBuilder::path, JsonpDeserializer.stringDeserializer(), "path", new String[0]);
        op.add(AbstractBuilder::port, JsonpDeserializer.numberDeserializer(), "port", new String[0]);
        op.add(AbstractBuilder::proxy, HttpInputProxy._DESERIALIZER, "proxy", new String[0]);
        op.add(AbstractBuilder::readTimeout, JsonpDeserializer.stringDeserializer(), "read_timeout", new String[0]);
        op.add(AbstractBuilder::scheme, ConnectionScheme._DESERIALIZER, "scheme", new String[0]);
        op.add(AbstractBuilder::url, JsonpDeserializer.stringDeserializer(), "url", new String[0]);
    }

    protected static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>> {
        @Nullable
        private HttpInputAuthentication auth;
        @Nullable
        private String body;
        @Nullable
        private String connectionTimeout;
        @Nullable
        private Map<String, String> headers;
        @Nullable
        private String host;
        @Nullable
        private HttpInputMethod method;
        @Nullable
        private Map<String, String> params;
        @Nullable
        private String path;
        @Nullable
        private Number port;
        @Nullable
        private HttpInputProxy proxy;
        @Nullable
        private String readTimeout;
        @Nullable
        private ConnectionScheme scheme;
        @Nullable
        private String url;

        protected AbstractBuilder() {
        }

        public BuilderT auth(@Nullable HttpInputAuthentication value) {
            this.auth = value;
            return this.self();
        }

        public BuilderT auth(Function<HttpInputAuthentication.Builder, ObjectBuilder<HttpInputAuthentication>> fn) {
            return this.auth(fn.apply(new HttpInputAuthentication.Builder()).build());
        }

        public BuilderT body(@Nullable String value) {
            this.body = value;
            return this.self();
        }

        public BuilderT connectionTimeout(@Nullable String value) {
            this.connectionTimeout = value;
            return this.self();
        }

        public BuilderT headers(@Nullable Map<String, String> value) {
            this.headers = value;
            return this.self();
        }

        public BuilderT putHeaders(String key, String value) {
            if (this.headers == null) {
                this.headers = new HashMap<String, String>();
            }
            this.headers.put(key, value);
            return this.self();
        }

        public BuilderT host(@Nullable String value) {
            this.host = value;
            return this.self();
        }

        public BuilderT method(@Nullable HttpInputMethod value) {
            this.method = value;
            return this.self();
        }

        public BuilderT params(@Nullable Map<String, String> value) {
            this.params = value;
            return this.self();
        }

        public BuilderT putParams(String key, String value) {
            if (this.params == null) {
                this.params = new HashMap<String, String>();
            }
            this.params.put(key, value);
            return this.self();
        }

        public BuilderT path(@Nullable String value) {
            this.path = value;
            return this.self();
        }

        public BuilderT port(@Nullable Number value) {
            this.port = value;
            return this.self();
        }

        public BuilderT proxy(@Nullable HttpInputProxy value) {
            this.proxy = value;
            return this.self();
        }

        public BuilderT proxy(Function<HttpInputProxy.Builder, ObjectBuilder<HttpInputProxy>> fn) {
            return this.proxy(fn.apply(new HttpInputProxy.Builder()).build());
        }

        public BuilderT readTimeout(@Nullable String value) {
            this.readTimeout = value;
            return this.self();
        }

        public BuilderT scheme(@Nullable ConnectionScheme value) {
            this.scheme = value;
            return this.self();
        }

        public BuilderT url(@Nullable String value) {
            this.url = value;
            return this.self();
        }

        protected abstract BuilderT self();
    }

    public static class Builder
    extends AbstractBuilder<Builder>
    implements ObjectBuilder<HttpInputRequestDefinition> {
        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public HttpInputRequestDefinition build() {
            return new HttpInputRequestDefinition(this);
        }
    }
}

