/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.watcher.ActionExecutionMode;
import co.elastic.clients.elasticsearch.watcher.ExecuteWatchResponse;
import co.elastic.clients.elasticsearch.watcher.ScheduleTriggerEvent;
import co.elastic.clients.elasticsearch.watcher.SimulatedActions;
import co.elastic.clients.elasticsearch.watcher.Watch;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class ExecuteWatchRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final String id;
    @Nullable
    private final Boolean debug;
    @Nullable
    private final Map<String, ActionExecutionMode> actionModes;
    @Nullable
    private final Map<String, JsonData> alternativeInput;
    @Nullable
    private final Boolean ignoreCondition;
    @Nullable
    private final Boolean recordExecution;
    @Nullable
    private final SimulatedActions simulatedActions;
    @Nullable
    private final ScheduleTriggerEvent triggerData;
    @Nullable
    private final Watch watch;
    public static final JsonpDeserializer<ExecuteWatchRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ExecuteWatchRequest::setupExecuteWatchRequestDeserializer, Builder::build);
    public static final Endpoint<ExecuteWatchRequest, ExecuteWatchResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<ExecuteWatchRequest, ExecuteWatchResponse>(request -> "PUT", request -> {
        boolean _id = true;
        boolean propsSet = false;
        if (request.id() != null) {
            propsSet |= true;
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_watcher");
            buf.append("/watch");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.id, buf);
            buf.append("/_execute");
            return buf.toString();
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_watcher");
            buf.append("/watch");
            buf.append("/_execute");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.debug != null) {
            params.put("debug", String.valueOf(request.debug));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, ExecuteWatchResponse._DESERIALIZER);

    public ExecuteWatchRequest(Builder builder) {
        this.id = builder.id;
        this.debug = builder.debug;
        this.actionModes = ModelTypeHelper.unmodifiable(builder.actionModes);
        this.alternativeInput = ModelTypeHelper.unmodifiable(builder.alternativeInput);
        this.ignoreCondition = builder.ignoreCondition;
        this.recordExecution = builder.recordExecution;
        this.simulatedActions = builder.simulatedActions;
        this.triggerData = builder.triggerData;
        this.watch = builder.watch;
    }

    public ExecuteWatchRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public String id() {
        return this.id;
    }

    @Nullable
    public Boolean debug() {
        return this.debug;
    }

    @Nullable
    public Map<String, ActionExecutionMode> actionModes() {
        return this.actionModes;
    }

    @Nullable
    public Map<String, JsonData> alternativeInput() {
        return this.alternativeInput;
    }

    @Nullable
    public Boolean ignoreCondition() {
        return this.ignoreCondition;
    }

    @Nullable
    public Boolean recordExecution() {
        return this.recordExecution;
    }

    @Nullable
    public SimulatedActions simulatedActions() {
        return this.simulatedActions;
    }

    @Nullable
    public ScheduleTriggerEvent triggerData() {
        return this.triggerData;
    }

    @Nullable
    public Watch watch() {
        return this.watch;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.actionModes != null) {
            generator.writeKey("action_modes");
            generator.writeStartObject();
            for (Map.Entry<String, JsonpSerializable> entry : this.actionModes.entrySet()) {
                generator.writeKey(entry.getKey());
                ((ActionExecutionMode)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.alternativeInput != null) {
            generator.writeKey("alternative_input");
            generator.writeStartObject();
            for (Map.Entry<String, JsonpSerializable> entry : this.alternativeInput.entrySet()) {
                generator.writeKey(entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.ignoreCondition != null) {
            generator.writeKey("ignore_condition");
            generator.write(this.ignoreCondition.booleanValue());
        }
        if (this.recordExecution != null) {
            generator.writeKey("record_execution");
            generator.write(this.recordExecution.booleanValue());
        }
        if (this.simulatedActions != null) {
            generator.writeKey("simulated_actions");
            this.simulatedActions.serialize(generator, mapper);
        }
        if (this.triggerData != null) {
            generator.writeKey("trigger_data");
            this.triggerData.serialize(generator, mapper);
        }
        if (this.watch != null) {
            generator.writeKey("watch");
            this.watch.serialize(generator, mapper);
        }
    }

    protected static void setupExecuteWatchRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::actionModes, JsonpDeserializer.stringMapDeserializer(ActionExecutionMode._DESERIALIZER), "action_modes", new String[0]);
        op.add(Builder::alternativeInput, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "alternative_input", new String[0]);
        op.add(Builder::ignoreCondition, JsonpDeserializer.booleanDeserializer(), "ignore_condition", new String[0]);
        op.add(Builder::recordExecution, JsonpDeserializer.booleanDeserializer(), "record_execution", new String[0]);
        op.add(Builder::simulatedActions, SimulatedActions._DESERIALIZER, "simulated_actions", new String[0]);
        op.add(Builder::triggerData, ScheduleTriggerEvent._DESERIALIZER, "trigger_data", new String[0]);
        op.add(Builder::watch, Watch._DESERIALIZER, "watch", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ExecuteWatchRequest> {
        @Nullable
        private String id;
        @Nullable
        private Boolean debug;
        @Nullable
        private Map<String, ActionExecutionMode> actionModes;
        @Nullable
        private Map<String, JsonData> alternativeInput;
        @Nullable
        private Boolean ignoreCondition;
        @Nullable
        private Boolean recordExecution;
        @Nullable
        private SimulatedActions simulatedActions;
        @Nullable
        private ScheduleTriggerEvent triggerData;
        @Nullable
        private Watch watch;

        public Builder id(@Nullable String value) {
            this.id = value;
            return this;
        }

        public Builder debug(@Nullable Boolean value) {
            this.debug = value;
            return this;
        }

        public Builder actionModes(@Nullable Map<String, ActionExecutionMode> value) {
            this.actionModes = value;
            return this;
        }

        public Builder putActionModes(String key, ActionExecutionMode value) {
            if (this.actionModes == null) {
                this.actionModes = new HashMap<String, ActionExecutionMode>();
            }
            this.actionModes.put(key, value);
            return this;
        }

        public Builder alternativeInput(@Nullable Map<String, JsonData> value) {
            this.alternativeInput = value;
            return this;
        }

        public Builder putAlternativeInput(String key, JsonData value) {
            if (this.alternativeInput == null) {
                this.alternativeInput = new HashMap<String, JsonData>();
            }
            this.alternativeInput.put(key, value);
            return this;
        }

        public Builder ignoreCondition(@Nullable Boolean value) {
            this.ignoreCondition = value;
            return this;
        }

        public Builder recordExecution(@Nullable Boolean value) {
            this.recordExecution = value;
            return this;
        }

        public Builder simulatedActions(@Nullable SimulatedActions value) {
            this.simulatedActions = value;
            return this;
        }

        public Builder simulatedActions(Function<SimulatedActions.Builder, ObjectBuilder<SimulatedActions>> fn) {
            return this.simulatedActions(fn.apply(new SimulatedActions.Builder()).build());
        }

        public Builder triggerData(@Nullable ScheduleTriggerEvent value) {
            this.triggerData = value;
            return this;
        }

        public Builder triggerData(Function<ScheduleTriggerEvent.Builder, ObjectBuilder<ScheduleTriggerEvent>> fn) {
            return this.triggerData(fn.apply(new ScheduleTriggerEvent.Builder()).build());
        }

        public Builder watch(@Nullable Watch value) {
            this.watch = value;
            return this;
        }

        public Builder watch(Function<Watch.Builder, ObjectBuilder<Watch>> fn) {
            return this.watch(fn.apply(new Watch.Builder()).build());
        }

        @Override
        public ExecuteWatchRequest build() {
            return new ExecuteWatchRequest(this);
        }
    }
}

