/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.elasticsearch.watcher.CompareContextPayloadCondition;
import co.elastic.clients.elasticsearch.watcher.ConditionVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class CompareCondition
implements ConditionVariant,
JsonpSerializable {
    @Nullable
    private final String comparison;
    @Nullable
    private final String path;
    @Nullable
    private final JsonData value;
    @Nullable
    private final CompareContextPayloadCondition ctxPayloadMatch;
    @Nullable
    private final CompareContextPayloadCondition ctxPayloadValue;
    public static final JsonpDeserializer<CompareCondition> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CompareCondition::setupCompareConditionDeserializer, Builder::build);

    public CompareCondition(Builder builder) {
        this.comparison = builder.comparison;
        this.path = builder.path;
        this.value = builder.value;
        this.ctxPayloadMatch = builder.ctxPayloadMatch;
        this.ctxPayloadValue = builder.ctxPayloadValue;
    }

    public CompareCondition(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "compare";
    }

    @Nullable
    public String comparison() {
        return this.comparison;
    }

    @Nullable
    public String path() {
        return this.path;
    }

    @Nullable
    public JsonData value() {
        return this.value;
    }

    @Nullable
    public CompareContextPayloadCondition ctxPayloadMatch() {
        return this.ctxPayloadMatch;
    }

    @Nullable
    public CompareContextPayloadCondition ctxPayloadValue() {
        return this.ctxPayloadValue;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.comparison != null) {
            generator.writeKey("comparison");
            generator.write(this.comparison);
        }
        if (this.path != null) {
            generator.writeKey("path");
            generator.write(this.path);
        }
        if (this.value != null) {
            generator.writeKey("value");
            this.value.serialize(generator, mapper);
        }
        if (this.ctxPayloadMatch != null) {
            generator.writeKey("ctx.payload.match");
            this.ctxPayloadMatch.serialize(generator, mapper);
        }
        if (this.ctxPayloadValue != null) {
            generator.writeKey("ctx.payload.value");
            this.ctxPayloadValue.serialize(generator, mapper);
        }
    }

    protected static void setupCompareConditionDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::comparison, JsonpDeserializer.stringDeserializer(), "comparison", new String[0]);
        op.add(Builder::path, JsonpDeserializer.stringDeserializer(), "path", new String[0]);
        op.add(Builder::value, JsonData._DESERIALIZER, "value", new String[0]);
        op.add(Builder::ctxPayloadMatch, CompareContextPayloadCondition._DESERIALIZER, "ctx.payload.match", new String[0]);
        op.add(Builder::ctxPayloadValue, CompareContextPayloadCondition._DESERIALIZER, "ctx.payload.value", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<CompareCondition> {
        @Nullable
        private String comparison;
        @Nullable
        private String path;
        @Nullable
        private JsonData value;
        @Nullable
        private CompareContextPayloadCondition ctxPayloadMatch;
        @Nullable
        private CompareContextPayloadCondition ctxPayloadValue;

        public Builder comparison(@Nullable String value) {
            this.comparison = value;
            return this;
        }

        public Builder path(@Nullable String value) {
            this.path = value;
            return this;
        }

        public Builder value(@Nullable JsonData value) {
            this.value = value;
            return this;
        }

        public Builder ctxPayloadMatch(@Nullable CompareContextPayloadCondition value) {
            this.ctxPayloadMatch = value;
            return this;
        }

        public Builder ctxPayloadMatch(Function<CompareContextPayloadCondition.Builder, ObjectBuilder<CompareContextPayloadCondition>> fn) {
            return this.ctxPayloadMatch(fn.apply(new CompareContextPayloadCondition.Builder()).build());
        }

        public Builder ctxPayloadValue(@Nullable CompareContextPayloadCondition value) {
            this.ctxPayloadValue = value;
            return this;
        }

        public Builder ctxPayloadValue(Function<CompareContextPayloadCondition.Builder, ObjectBuilder<CompareContextPayloadCondition>> fn) {
            return this.ctxPayloadValue(fn.apply(new CompareContextPayloadCondition.Builder()).build());
        }

        @Override
        public CompareCondition build() {
            return new CompareCondition(this);
        }
    }
}

