/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.elasticsearch.watcher.Input;
import co.elastic.clients.elasticsearch.watcher.InputVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public final class ChainInput
implements InputVariant,
JsonpSerializable {
    private final List<Input> inputs;
    public static final JsonpDeserializer<ChainInput> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ChainInput::setupChainInputDeserializer, Builder::build);

    public ChainInput(Builder builder) {
        this.inputs = ModelTypeHelper.unmodifiableNonNull(builder.inputs, "inputs");
    }

    public ChainInput(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "chain";
    }

    public List<Input> inputs() {
        return this.inputs;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("inputs");
        generator.writeStartArray();
        for (Input item0 : this.inputs) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupChainInputDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::inputs, JsonpDeserializer.arrayDeserializer(Input._DESERIALIZER), "inputs", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ChainInput> {
        private List<Input> inputs;

        public Builder inputs(List<Input> value) {
            this.inputs = value;
            return this;
        }

        public Builder inputs(Input ... value) {
            this.inputs = Arrays.asList(value);
            return this;
        }

        public Builder addInputs(Input value) {
            if (this.inputs == null) {
                this.inputs = new ArrayList<Input>();
            }
            this.inputs.add(value);
            return this;
        }

        public Builder inputs(Function<Input.Builder, ObjectBuilder<Input>> fn) {
            return this.inputs(fn.apply(new Input.Builder()).build());
        }

        public Builder addInputs(Function<Input.Builder, ObjectBuilder<Input>> fn) {
            return this.addInputs(fn.apply(new Input.Builder()).build());
        }

        @Override
        public ChainInput build() {
            return new ChainInput(this);
        }
    }
}

