/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.transform;

import co.elastic.clients.elasticsearch.indices.IndexState;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpSerializer;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class PreviewTransformResponse<TTransform>
implements JsonpSerializable {
    private final IndexState generatedDestIndex;
    private final List<TTransform> preview;
    @Nullable
    private final JsonpSerializer<TTransform> tTransformSerializer;

    public PreviewTransformResponse(Builder<TTransform> builder) {
        this.generatedDestIndex = Objects.requireNonNull(((Builder)builder).generatedDestIndex, "generated_dest_index");
        this.preview = ModelTypeHelper.unmodifiableNonNull(((Builder)builder).preview, "preview");
        this.tTransformSerializer = ((Builder)builder).tTransformSerializer;
    }

    public PreviewTransformResponse(Function<Builder<TTransform>, Builder<TTransform>> fn) {
        this(fn.apply(new Builder()));
    }

    public IndexState generatedDestIndex() {
        return this.generatedDestIndex;
    }

    public List<TTransform> preview() {
        return this.preview;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("generated_dest_index");
        this.generatedDestIndex.serialize(generator, mapper);
        generator.writeKey("preview");
        generator.writeStartArray();
        for (TTransform item0 : this.preview) {
            JsonpUtils.serialize(item0, generator, this.tTransformSerializer, mapper);
        }
        generator.writeEnd();
    }

    public static <TTransform> JsonpDeserializer<PreviewTransformResponse<TTransform>> createPreviewTransformResponseDeserializer(JsonpDeserializer<TTransform> tTransformDeserializer) {
        return ObjectBuilderDeserializer.createForObject(Builder::new, op -> PreviewTransformResponse.setupPreviewTransformResponseDeserializer(op, tTransformDeserializer));
    }

    protected static <TTransform> void setupPreviewTransformResponseDeserializer(DelegatingDeserializer<Builder<TTransform>> op, JsonpDeserializer<TTransform> tTransformDeserializer) {
        op.add(Builder::generatedDestIndex, IndexState._DESERIALIZER, "generated_dest_index", new String[0]);
        op.add(Builder::preview, JsonpDeserializer.arrayDeserializer(tTransformDeserializer), "preview", new String[0]);
    }

    public static class Builder<TTransform>
    implements ObjectBuilder<PreviewTransformResponse<TTransform>> {
        private IndexState generatedDestIndex;
        private List<TTransform> preview;
        @Nullable
        private JsonpSerializer<TTransform> tTransformSerializer;

        public Builder<TTransform> generatedDestIndex(IndexState value) {
            this.generatedDestIndex = value;
            return this;
        }

        public Builder<TTransform> generatedDestIndex(Function<IndexState.Builder, ObjectBuilder<IndexState>> fn) {
            return this.generatedDestIndex(fn.apply(new IndexState.Builder()).build());
        }

        public Builder<TTransform> preview(List<TTransform> value) {
            this.preview = value;
            return this;
        }

        public Builder<TTransform> preview(TTransform ... value) {
            this.preview = Arrays.asList(value);
            return this;
        }

        public Builder<TTransform> addPreview(TTransform value) {
            if (this.preview == null) {
                this.preview = new ArrayList<TTransform>();
            }
            this.preview.add(value);
            return this;
        }

        public Builder<TTransform> tTransformSerializer(@Nullable JsonpSerializer<TTransform> value) {
            this.tTransformSerializer = value;
            return this;
        }

        @Override
        public PreviewTransformResponse<TTransform> build() {
            return new PreviewTransformResponse(this);
        }
    }
}

