/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.tasks;

import co.elastic.clients.elasticsearch._types.ErrorCause;
import co.elastic.clients.elasticsearch.tasks.TaskExecutingNode;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class CancelResponse
implements JsonpSerializable {
    @Nullable
    private final List<ErrorCause> nodeFailures;
    private final Map<String, TaskExecutingNode> nodes;
    public static final JsonpDeserializer<CancelResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CancelResponse::setupCancelResponseDeserializer, Builder::build);

    public CancelResponse(Builder builder) {
        this.nodeFailures = ModelTypeHelper.unmodifiable(builder.nodeFailures);
        this.nodes = ModelTypeHelper.unmodifiableNonNull(builder.nodes, "nodes");
    }

    public CancelResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public List<ErrorCause> nodeFailures() {
        return this.nodeFailures;
    }

    public Map<String, TaskExecutingNode> nodes() {
        return this.nodes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.nodeFailures != null) {
            generator.writeKey("node_failures");
            generator.writeStartArray();
            for (ErrorCause errorCause : this.nodeFailures) {
                errorCause.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("nodes");
        generator.writeStartObject();
        for (Map.Entry entry : this.nodes.entrySet()) {
            generator.writeKey((String)entry.getKey());
            ((TaskExecutingNode)entry.getValue()).serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupCancelResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::nodeFailures, JsonpDeserializer.arrayDeserializer(ErrorCause._DESERIALIZER), "node_failures", new String[0]);
        op.add(Builder::nodes, JsonpDeserializer.stringMapDeserializer(TaskExecutingNode._DESERIALIZER), "nodes", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<CancelResponse> {
        @Nullable
        private List<ErrorCause> nodeFailures;
        private Map<String, TaskExecutingNode> nodes;

        public Builder nodeFailures(@Nullable List<ErrorCause> value) {
            this.nodeFailures = value;
            return this;
        }

        public Builder nodeFailures(ErrorCause ... value) {
            this.nodeFailures = Arrays.asList(value);
            return this;
        }

        public Builder addNodeFailures(ErrorCause value) {
            if (this.nodeFailures == null) {
                this.nodeFailures = new ArrayList<ErrorCause>();
            }
            this.nodeFailures.add(value);
            return this;
        }

        public Builder nodeFailures(Function<ErrorCause.Builder, ObjectBuilder<ErrorCause>> fn) {
            return this.nodeFailures(fn.apply(new ErrorCause.Builder()).build());
        }

        public Builder addNodeFailures(Function<ErrorCause.Builder, ObjectBuilder<ErrorCause>> fn) {
            return this.addNodeFailures(fn.apply(new ErrorCause.Builder()).build());
        }

        public Builder nodes(Map<String, TaskExecutingNode> value) {
            this.nodes = value;
            return this;
        }

        public Builder putNodes(String key, TaskExecutingNode value) {
            if (this.nodes == null) {
                this.nodes = new HashMap<String, TaskExecutingNode>();
            }
            this.nodes.put(key, value);
            return this;
        }

        public Builder nodes(String key, Function<TaskExecutingNode.Builder, ObjectBuilder<TaskExecutingNode>> fn) {
            return this.nodes(Collections.singletonMap(key, fn.apply(new TaskExecutingNode.Builder()).build()));
        }

        public Builder putNodes(String key, Function<TaskExecutingNode.Builder, ObjectBuilder<TaskExecutingNode>> fn) {
            return this.putNodes(key, fn.apply(new TaskExecutingNode.Builder()).build());
        }

        @Override
        public CancelResponse build() {
            return new CancelResponse(this);
        }
    }
}

