/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.snapshot;

import co.elastic.clients.elasticsearch.snapshot.ShardsStats;
import co.elastic.clients.elasticsearch.snapshot.SnapshotShardsStatus;
import co.elastic.clients.elasticsearch.snapshot.SnapshotStats;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class SnapshotIndexStats
implements JsonpSerializable {
    private final Map<String, SnapshotShardsStatus> shards;
    private final ShardsStats shardsStats;
    private final SnapshotStats stats;
    public static final JsonpDeserializer<SnapshotIndexStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SnapshotIndexStats::setupSnapshotIndexStatsDeserializer, Builder::build);

    public SnapshotIndexStats(Builder builder) {
        this.shards = ModelTypeHelper.unmodifiableNonNull(builder.shards, "shards");
        this.shardsStats = Objects.requireNonNull(builder.shardsStats, "shards_stats");
        this.stats = Objects.requireNonNull(builder.stats, "stats");
    }

    public SnapshotIndexStats(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public Map<String, SnapshotShardsStatus> shards() {
        return this.shards;
    }

    public ShardsStats shardsStats() {
        return this.shardsStats;
    }

    public SnapshotStats stats() {
        return this.stats;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("shards");
        generator.writeStartObject();
        for (Map.Entry<String, SnapshotShardsStatus> item0 : this.shards.entrySet()) {
            generator.writeKey(item0.getKey());
            item0.getValue().serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("shards_stats");
        this.shardsStats.serialize(generator, mapper);
        generator.writeKey("stats");
        this.stats.serialize(generator, mapper);
    }

    protected static void setupSnapshotIndexStatsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::shards, JsonpDeserializer.stringMapDeserializer(SnapshotShardsStatus._DESERIALIZER), "shards", new String[0]);
        op.add(Builder::shardsStats, ShardsStats._DESERIALIZER, "shards_stats", new String[0]);
        op.add(Builder::stats, SnapshotStats._DESERIALIZER, "stats", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<SnapshotIndexStats> {
        private Map<String, SnapshotShardsStatus> shards;
        private ShardsStats shardsStats;
        private SnapshotStats stats;

        public Builder shards(Map<String, SnapshotShardsStatus> value) {
            this.shards = value;
            return this;
        }

        public Builder putShards(String key, SnapshotShardsStatus value) {
            if (this.shards == null) {
                this.shards = new HashMap<String, SnapshotShardsStatus>();
            }
            this.shards.put(key, value);
            return this;
        }

        public Builder shards(String key, Function<SnapshotShardsStatus.Builder, ObjectBuilder<SnapshotShardsStatus>> fn) {
            return this.shards(Collections.singletonMap(key, fn.apply(new SnapshotShardsStatus.Builder()).build()));
        }

        public Builder putShards(String key, Function<SnapshotShardsStatus.Builder, ObjectBuilder<SnapshotShardsStatus>> fn) {
            return this.putShards(key, fn.apply(new SnapshotShardsStatus.Builder()).build());
        }

        public Builder shardsStats(ShardsStats value) {
            this.shardsStats = value;
            return this;
        }

        public Builder shardsStats(Function<ShardsStats.Builder, ObjectBuilder<ShardsStats>> fn) {
            return this.shardsStats(fn.apply(new ShardsStats.Builder()).build());
        }

        public Builder stats(SnapshotStats value) {
            this.stats = value;
            return this;
        }

        public Builder stats(Function<SnapshotStats.Builder, ObjectBuilder<SnapshotStats>> fn) {
            return this.stats(fn.apply(new SnapshotStats.Builder()).build());
        }

        @Override
        public SnapshotIndexStats build() {
            return new SnapshotIndexStats(this);
        }
    }
}

