/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.slm;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.slm.ExecuteLifecycleResponse;
import co.elastic.clients.util.ObjectBuilder;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Function;

public final class ExecuteLifecycleRequest
extends RequestBase {
    private final String policyId;
    public static final Endpoint<ExecuteLifecycleRequest, ExecuteLifecycleResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<ExecuteLifecycleRequest, ExecuteLifecycleResponse>(request -> "PUT", request -> {
        boolean _policyId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_slm");
            buf.append("/policy");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.policyId, buf);
            buf.append("/_execute");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), false, ExecuteLifecycleResponse._DESERIALIZER);

    public ExecuteLifecycleRequest(Builder builder) {
        this.policyId = Objects.requireNonNull(builder.policyId, "policy_id");
    }

    public ExecuteLifecycleRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String policyId() {
        return this.policyId;
    }

    public static class Builder
    implements ObjectBuilder<ExecuteLifecycleRequest> {
        private String policyId;

        public Builder policyId(String value) {
            this.policyId = value;
            return this;
        }

        @Override
        public ExecuteLifecycleRequest build() {
            return new ExecuteLifecycleRequest(this);
        }
    }
}

