/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.shutdown.get_node;

import co.elastic.clients.elasticsearch.shutdown.get_node.PersistentTaskStatus;
import co.elastic.clients.elasticsearch.shutdown.get_node.PluginsStatus;
import co.elastic.clients.elasticsearch.shutdown.get_node.ShardMigrationStatus;
import co.elastic.clients.elasticsearch.shutdown.get_node.ShutdownStatus;
import co.elastic.clients.elasticsearch.shutdown.get_node.ShutdownType;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class NodeShutdownStatus
implements JsonpSerializable {
    private final String nodeId;
    private final ShutdownType type;
    private final String reason;
    private final String shutdownStartedmillis;
    private final ShutdownStatus status;
    private final ShardMigrationStatus shardMigration;
    private final PersistentTaskStatus persistentTasks;
    private final PluginsStatus plugins;
    public static final JsonpDeserializer<NodeShutdownStatus> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NodeShutdownStatus::setupNodeShutdownStatusDeserializer, Builder::build);

    public NodeShutdownStatus(Builder builder) {
        this.nodeId = Objects.requireNonNull(builder.nodeId, "node_id");
        this.type = Objects.requireNonNull(builder.type, "type");
        this.reason = Objects.requireNonNull(builder.reason, "reason");
        this.shutdownStartedmillis = Objects.requireNonNull(builder.shutdownStartedmillis, "shutdown_startedmillis");
        this.status = Objects.requireNonNull(builder.status, "status");
        this.shardMigration = Objects.requireNonNull(builder.shardMigration, "shard_migration");
        this.persistentTasks = Objects.requireNonNull(builder.persistentTasks, "persistent_tasks");
        this.plugins = Objects.requireNonNull(builder.plugins, "plugins");
    }

    public NodeShutdownStatus(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String nodeId() {
        return this.nodeId;
    }

    public ShutdownType type() {
        return this.type;
    }

    public String reason() {
        return this.reason;
    }

    public String shutdownStartedmillis() {
        return this.shutdownStartedmillis;
    }

    public ShutdownStatus status() {
        return this.status;
    }

    public ShardMigrationStatus shardMigration() {
        return this.shardMigration;
    }

    public PersistentTaskStatus persistentTasks() {
        return this.persistentTasks;
    }

    public PluginsStatus plugins() {
        return this.plugins;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("node_id");
        generator.write(this.nodeId);
        generator.writeKey("type");
        this.type.serialize(generator, mapper);
        generator.writeKey("reason");
        generator.write(this.reason);
        generator.writeKey("shutdown_startedmillis");
        generator.write(this.shutdownStartedmillis);
        generator.writeKey("status");
        this.status.serialize(generator, mapper);
        generator.writeKey("shard_migration");
        this.shardMigration.serialize(generator, mapper);
        generator.writeKey("persistent_tasks");
        this.persistentTasks.serialize(generator, mapper);
        generator.writeKey("plugins");
        this.plugins.serialize(generator, mapper);
    }

    protected static void setupNodeShutdownStatusDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::nodeId, JsonpDeserializer.stringDeserializer(), "node_id", new String[0]);
        op.add(Builder::type, ShutdownType._DESERIALIZER, "type", new String[0]);
        op.add(Builder::reason, JsonpDeserializer.stringDeserializer(), "reason", new String[0]);
        op.add(Builder::shutdownStartedmillis, JsonpDeserializer.stringDeserializer(), "shutdown_startedmillis", new String[0]);
        op.add(Builder::status, ShutdownStatus._DESERIALIZER, "status", new String[0]);
        op.add(Builder::shardMigration, ShardMigrationStatus._DESERIALIZER, "shard_migration", new String[0]);
        op.add(Builder::persistentTasks, PersistentTaskStatus._DESERIALIZER, "persistent_tasks", new String[0]);
        op.add(Builder::plugins, PluginsStatus._DESERIALIZER, "plugins", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<NodeShutdownStatus> {
        private String nodeId;
        private ShutdownType type;
        private String reason;
        private String shutdownStartedmillis;
        private ShutdownStatus status;
        private ShardMigrationStatus shardMigration;
        private PersistentTaskStatus persistentTasks;
        private PluginsStatus plugins;

        public Builder nodeId(String value) {
            this.nodeId = value;
            return this;
        }

        public Builder type(ShutdownType value) {
            this.type = value;
            return this;
        }

        public Builder reason(String value) {
            this.reason = value;
            return this;
        }

        public Builder shutdownStartedmillis(String value) {
            this.shutdownStartedmillis = value;
            return this;
        }

        public Builder status(ShutdownStatus value) {
            this.status = value;
            return this;
        }

        public Builder shardMigration(ShardMigrationStatus value) {
            this.shardMigration = value;
            return this;
        }

        public Builder shardMigration(Function<ShardMigrationStatus.Builder, ObjectBuilder<ShardMigrationStatus>> fn) {
            return this.shardMigration(fn.apply(new ShardMigrationStatus.Builder()).build());
        }

        public Builder persistentTasks(PersistentTaskStatus value) {
            this.persistentTasks = value;
            return this;
        }

        public Builder persistentTasks(Function<PersistentTaskStatus.Builder, ObjectBuilder<PersistentTaskStatus>> fn) {
            return this.persistentTasks(fn.apply(new PersistentTaskStatus.Builder()).build());
        }

        public Builder plugins(PluginsStatus value) {
            this.plugins = value;
            return this;
        }

        public Builder plugins(Function<PluginsStatus.Builder, ObjectBuilder<PluginsStatus>> fn) {
            return this.plugins(fn.apply(new PluginsStatus.Builder()).build());
        }

        @Override
        public NodeShutdownStatus build() {
            return new NodeShutdownStatus(this);
        }
    }
}

