/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security.put_privileges;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class Actions
implements JsonpSerializable {
    private final List<String> actions;
    @Nullable
    private final String application;
    @Nullable
    private final String name;
    @Nullable
    private final Map<String, JsonData> metadata;
    public static final JsonpDeserializer<Actions> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Actions::setupActionsDeserializer, Builder::build);

    public Actions(Builder builder) {
        this.actions = ModelTypeHelper.unmodifiableNonNull(builder.actions, "actions");
        this.application = builder.application;
        this.name = builder.name;
        this.metadata = ModelTypeHelper.unmodifiable(builder.metadata);
    }

    public Actions(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<String> actions() {
        return this.actions;
    }

    @Nullable
    public String application() {
        return this.application;
    }

    @Nullable
    public String name() {
        return this.name;
    }

    @Nullable
    public Map<String, JsonData> metadata() {
        return this.metadata;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("actions");
        generator.writeStartArray();
        for (String string : this.actions) {
            generator.write(string);
        }
        generator.writeEnd();
        if (this.application != null) {
            generator.writeKey("application");
            generator.write(this.application);
        }
        if (this.name != null) {
            generator.writeKey("name");
            generator.write(this.name);
        }
        if (this.metadata != null) {
            generator.writeKey("metadata");
            generator.writeStartObject();
            for (Map.Entry entry : this.metadata.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupActionsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::actions, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "actions", new String[0]);
        op.add(Builder::application, JsonpDeserializer.stringDeserializer(), "application", new String[0]);
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name", new String[0]);
        op.add(Builder::metadata, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "metadata", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<Actions> {
        private List<String> actions;
        @Nullable
        private String application;
        @Nullable
        private String name;
        @Nullable
        private Map<String, JsonData> metadata;

        public Builder actions(List<String> value) {
            this.actions = value;
            return this;
        }

        public Builder actions(String ... value) {
            this.actions = Arrays.asList(value);
            return this;
        }

        public Builder addActions(String value) {
            if (this.actions == null) {
                this.actions = new ArrayList<String>();
            }
            this.actions.add(value);
            return this;
        }

        public Builder application(@Nullable String value) {
            this.application = value;
            return this;
        }

        public Builder name(@Nullable String value) {
            this.name = value;
            return this;
        }

        public Builder metadata(@Nullable Map<String, JsonData> value) {
            this.metadata = value;
            return this;
        }

        public Builder putMetadata(String key, JsonData value) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, JsonData>();
            }
            this.metadata.put(key, value);
            return this;
        }

        @Override
        public Actions build() {
            return new Actions(this);
        }
    }
}

