/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch._types.ErrorCause;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class InvalidateApiKeyResponse
implements JsonpSerializable {
    private final int errorCount;
    @Nullable
    private final List<ErrorCause> errorDetails;
    private final List<String> invalidatedApiKeys;
    private final List<String> previouslyInvalidatedApiKeys;
    public static final JsonpDeserializer<InvalidateApiKeyResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, InvalidateApiKeyResponse::setupInvalidateApiKeyResponseDeserializer, Builder::build);

    public InvalidateApiKeyResponse(Builder builder) {
        this.errorCount = Objects.requireNonNull(builder.errorCount, "error_count");
        this.errorDetails = ModelTypeHelper.unmodifiable(builder.errorDetails);
        this.invalidatedApiKeys = ModelTypeHelper.unmodifiableNonNull(builder.invalidatedApiKeys, "invalidated_api_keys");
        this.previouslyInvalidatedApiKeys = ModelTypeHelper.unmodifiableNonNull(builder.previouslyInvalidatedApiKeys, "previously_invalidated_api_keys");
    }

    public InvalidateApiKeyResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public int errorCount() {
        return this.errorCount;
    }

    @Nullable
    public List<ErrorCause> errorDetails() {
        return this.errorDetails;
    }

    public List<String> invalidatedApiKeys() {
        return this.invalidatedApiKeys;
    }

    public List<String> previouslyInvalidatedApiKeys() {
        return this.previouslyInvalidatedApiKeys;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("error_count");
        generator.write(this.errorCount);
        if (this.errorDetails != null) {
            generator.writeKey("error_details");
            generator.writeStartArray();
            for (ErrorCause errorCause : this.errorDetails) {
                errorCause.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("invalidated_api_keys");
        generator.writeStartArray();
        for (String string : this.invalidatedApiKeys) {
            generator.write(string);
        }
        generator.writeEnd();
        generator.writeKey("previously_invalidated_api_keys");
        generator.writeStartArray();
        for (String string : this.previouslyInvalidatedApiKeys) {
            generator.write(string);
        }
        generator.writeEnd();
    }

    protected static void setupInvalidateApiKeyResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::errorCount, JsonpDeserializer.integerDeserializer(), "error_count", new String[0]);
        op.add(Builder::errorDetails, JsonpDeserializer.arrayDeserializer(ErrorCause._DESERIALIZER), "error_details", new String[0]);
        op.add(Builder::invalidatedApiKeys, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "invalidated_api_keys", new String[0]);
        op.add(Builder::previouslyInvalidatedApiKeys, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "previously_invalidated_api_keys", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<InvalidateApiKeyResponse> {
        private Integer errorCount;
        @Nullable
        private List<ErrorCause> errorDetails;
        private List<String> invalidatedApiKeys;
        private List<String> previouslyInvalidatedApiKeys;

        public Builder errorCount(int value) {
            this.errorCount = value;
            return this;
        }

        public Builder errorDetails(@Nullable List<ErrorCause> value) {
            this.errorDetails = value;
            return this;
        }

        public Builder errorDetails(ErrorCause ... value) {
            this.errorDetails = Arrays.asList(value);
            return this;
        }

        public Builder addErrorDetails(ErrorCause value) {
            if (this.errorDetails == null) {
                this.errorDetails = new ArrayList<ErrorCause>();
            }
            this.errorDetails.add(value);
            return this;
        }

        public Builder errorDetails(Function<ErrorCause.Builder, ObjectBuilder<ErrorCause>> fn) {
            return this.errorDetails(fn.apply(new ErrorCause.Builder()).build());
        }

        public Builder addErrorDetails(Function<ErrorCause.Builder, ObjectBuilder<ErrorCause>> fn) {
            return this.addErrorDetails(fn.apply(new ErrorCause.Builder()).build());
        }

        public Builder invalidatedApiKeys(List<String> value) {
            this.invalidatedApiKeys = value;
            return this;
        }

        public Builder invalidatedApiKeys(String ... value) {
            this.invalidatedApiKeys = Arrays.asList(value);
            return this;
        }

        public Builder addInvalidatedApiKeys(String value) {
            if (this.invalidatedApiKeys == null) {
                this.invalidatedApiKeys = new ArrayList<String>();
            }
            this.invalidatedApiKeys.add(value);
            return this;
        }

        public Builder previouslyInvalidatedApiKeys(List<String> value) {
            this.previouslyInvalidatedApiKeys = value;
            return this;
        }

        public Builder previouslyInvalidatedApiKeys(String ... value) {
            this.previouslyInvalidatedApiKeys = Arrays.asList(value);
            return this;
        }

        public Builder addPreviouslyInvalidatedApiKeys(String value) {
            if (this.previouslyInvalidatedApiKeys == null) {
                this.previouslyInvalidatedApiKeys = new ArrayList<String>();
            }
            this.previouslyInvalidatedApiKeys.add(value);
            return this;
        }

        @Override
        public InvalidateApiKeyResponse build() {
            return new InvalidateApiKeyResponse(this);
        }
    }
}

