/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.security.EnableUserResponse;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class EnableUserRequest
extends RequestBase {
    private final String username;
    @Nullable
    private final JsonValue refresh;
    public static final Endpoint<EnableUserRequest, EnableUserResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<EnableUserRequest, EnableUserResponse>(request -> "PUT", request -> {
        boolean _username = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_security");
            buf.append("/user");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.username, buf);
            buf.append("/_enable");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.refresh != null) {
            params.put("refresh", JsonpUtils.toString(request.refresh));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, EnableUserResponse._DESERIALIZER);

    public EnableUserRequest(Builder builder) {
        this.username = Objects.requireNonNull(builder.username, "username");
        this.refresh = builder.refresh;
    }

    public EnableUserRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String username() {
        return this.username;
    }

    @Nullable
    public JsonValue refresh() {
        return this.refresh;
    }

    public static class Builder
    implements ObjectBuilder<EnableUserRequest> {
        private String username;
        @Nullable
        private JsonValue refresh;

        public Builder username(String value) {
            this.username = value;
            return this;
        }

        public Builder refresh(@Nullable JsonValue value) {
            this.refresh = value;
            return this;
        }

        @Override
        public EnableUserRequest build() {
            return new EnableUserRequest(this);
        }
    }
}

