/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.security.ClearCachedRealmsResponse;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class ClearCachedRealmsRequest
extends RequestBase {
    private final List<String> realms;
    @Nullable
    private final List<String> usernames;
    public static final Endpoint<ClearCachedRealmsRequest, ClearCachedRealmsResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<ClearCachedRealmsRequest, ClearCachedRealmsResponse>(request -> "POST", request -> {
        boolean _realms = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_security");
            buf.append("/realm");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.realms.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/_clear_cache");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.usernames != null) {
            params.put("usernames", request.usernames.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, ClearCachedRealmsResponse._DESERIALIZER);

    public ClearCachedRealmsRequest(Builder builder) {
        this.realms = ModelTypeHelper.unmodifiableNonNull(builder.realms, "realms");
        this.usernames = ModelTypeHelper.unmodifiable(builder.usernames);
    }

    public ClearCachedRealmsRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<String> realms() {
        return this.realms;
    }

    @Nullable
    public List<String> usernames() {
        return this.usernames;
    }

    public static class Builder
    implements ObjectBuilder<ClearCachedRealmsRequest> {
        private List<String> realms;
        @Nullable
        private List<String> usernames;

        public Builder realms(List<String> value) {
            this.realms = value;
            return this;
        }

        public Builder realms(String ... value) {
            this.realms = Arrays.asList(value);
            return this;
        }

        public Builder addRealms(String value) {
            if (this.realms == null) {
                this.realms = new ArrayList<String>();
            }
            this.realms.add(value);
            return this;
        }

        public Builder usernames(@Nullable List<String> value) {
            this.usernames = value;
            return this;
        }

        public Builder usernames(String ... value) {
            this.usernames = Arrays.asList(value);
            return this;
        }

        public Builder addUsernames(String value) {
            if (this.usernames == null) {
                this.usernames = new ArrayList<String>();
            }
            this.usernames.add(value);
            return this;
        }

        @Override
        public ClearCachedRealmsRequest build() {
            return new ClearCachedRealmsRequest(this);
        }
    }
}

