/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.searchable_snapshots;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.searchable_snapshots.StatsLevel;
import co.elastic.clients.elasticsearch.searchable_snapshots.StatsResponse;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class StatsRequest
extends RequestBase {
    @Nullable
    private final List<String> index;
    @Nullable
    private final StatsLevel level;
    public static final Endpoint<StatsRequest, StatsResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<StatsRequest, StatsResponse>(request -> "GET", request -> {
        boolean _index = true;
        boolean propsSet = false;
        if (request.index() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_searchable_snapshots");
            buf.append("/stats");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/_searchable_snapshots");
            buf.append("/stats");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.level != null) {
            params.put("level", request.level.toString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, StatsResponse._DESERIALIZER);

    public StatsRequest(Builder builder) {
        this.index = ModelTypeHelper.unmodifiable(builder.index);
        this.level = builder.level;
    }

    public StatsRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public List<String> index() {
        return this.index;
    }

    @Nullable
    public StatsLevel level() {
        return this.level;
    }

    public static class Builder
    implements ObjectBuilder<StatsRequest> {
        @Nullable
        private List<String> index;
        @Nullable
        private StatsLevel level;

        public Builder index(@Nullable List<String> value) {
            this.index = value;
            return this;
        }

        public Builder index(String ... value) {
            this.index = Arrays.asList(value);
            return this;
        }

        public Builder addIndex(String value) {
            if (this.index == null) {
                this.index = new ArrayList<String>();
            }
            this.index.add(value);
            return this;
        }

        public Builder level(@Nullable StatsLevel value) {
            this.level = value;
            return this;
        }

        @Override
        public StatsRequest build() {
            return new StatsRequest(this);
        }
    }
}

