/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.rollup;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.rollup.RollupResponse;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class RollupRequest
extends RequestBase
implements JsonpSerializable {
    private final String index;
    private final String rollupIndex;
    private final JsonData config;
    public static final JsonpDeserializer<RollupRequest> _DESERIALIZER = RollupRequest.createRollupRequestDeserializer();
    public static final Endpoint<RollupRequest, RollupResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<RollupRequest, RollupResponse>(request -> "POST", request -> {
        boolean _index = true;
        int _rollupIndex = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index, buf);
            buf.append("/_rollup");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.rollupIndex, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, RollupResponse._DESERIALIZER);

    public RollupRequest(Builder builder) {
        this.index = Objects.requireNonNull(builder.index, "index");
        this.rollupIndex = Objects.requireNonNull(builder.rollupIndex, "rollup_index");
        this.config = Objects.requireNonNull(builder.config, "_value_body");
    }

    public RollupRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String index() {
        return this.index;
    }

    public String rollupIndex() {
        return this.rollupIndex;
    }

    public JsonData config() {
        return this.config;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        this.config.serialize(generator, mapper);
    }

    protected static JsonpDeserializer<RollupRequest> createRollupRequestDeserializer() {
        JsonpDeserializer<JsonData> valueDeserializer = JsonData._DESERIALIZER;
        return JsonpDeserializer.of(valueDeserializer.acceptedEvents(), (parser, mapper, event) -> new Builder().config((JsonData)valueDeserializer.deserialize((JsonParser)parser, (JsonpMapper)mapper, (JsonParser.Event)event)).build());
    }

    public static class Builder
    implements ObjectBuilder<RollupRequest> {
        private String index;
        private String rollupIndex;
        private JsonData config;

        public Builder index(String value) {
            this.index = value;
            return this;
        }

        public Builder rollupIndex(String value) {
            this.rollupIndex = value;
            return this;
        }

        public Builder config(JsonData value) {
            this.config = value;
            return this;
        }

        @Override
        public RollupRequest build() {
            return new RollupRequest(this);
        }
    }
}

