/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class DataPathStats
implements JsonpSerializable {
    private final String available;
    private final long availableInBytes;
    private final String diskQueue;
    private final long diskReads;
    private final String diskReadSize;
    private final long diskReadSizeInBytes;
    private final long diskWrites;
    private final String diskWriteSize;
    private final long diskWriteSizeInBytes;
    private final String free;
    private final long freeInBytes;
    private final String mount;
    private final String path;
    private final String total;
    private final long totalInBytes;
    private final String type;
    public static final JsonpDeserializer<DataPathStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DataPathStats::setupDataPathStatsDeserializer, Builder::build);

    public DataPathStats(Builder builder) {
        this.available = Objects.requireNonNull(builder.available, "available");
        this.availableInBytes = Objects.requireNonNull(builder.availableInBytes, "available_in_bytes");
        this.diskQueue = Objects.requireNonNull(builder.diskQueue, "disk_queue");
        this.diskReads = Objects.requireNonNull(builder.diskReads, "disk_reads");
        this.diskReadSize = Objects.requireNonNull(builder.diskReadSize, "disk_read_size");
        this.diskReadSizeInBytes = Objects.requireNonNull(builder.diskReadSizeInBytes, "disk_read_size_in_bytes");
        this.diskWrites = Objects.requireNonNull(builder.diskWrites, "disk_writes");
        this.diskWriteSize = Objects.requireNonNull(builder.diskWriteSize, "disk_write_size");
        this.diskWriteSizeInBytes = Objects.requireNonNull(builder.diskWriteSizeInBytes, "disk_write_size_in_bytes");
        this.free = Objects.requireNonNull(builder.free, "free");
        this.freeInBytes = Objects.requireNonNull(builder.freeInBytes, "free_in_bytes");
        this.mount = Objects.requireNonNull(builder.mount, "mount");
        this.path = Objects.requireNonNull(builder.path, "path");
        this.total = Objects.requireNonNull(builder.total, "total");
        this.totalInBytes = Objects.requireNonNull(builder.totalInBytes, "total_in_bytes");
        this.type = Objects.requireNonNull(builder.type, "type");
    }

    public DataPathStats(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String available() {
        return this.available;
    }

    public long availableInBytes() {
        return this.availableInBytes;
    }

    public String diskQueue() {
        return this.diskQueue;
    }

    public long diskReads() {
        return this.diskReads;
    }

    public String diskReadSize() {
        return this.diskReadSize;
    }

    public long diskReadSizeInBytes() {
        return this.diskReadSizeInBytes;
    }

    public long diskWrites() {
        return this.diskWrites;
    }

    public String diskWriteSize() {
        return this.diskWriteSize;
    }

    public long diskWriteSizeInBytes() {
        return this.diskWriteSizeInBytes;
    }

    public String free() {
        return this.free;
    }

    public long freeInBytes() {
        return this.freeInBytes;
    }

    public String mount() {
        return this.mount;
    }

    public String path() {
        return this.path;
    }

    public String total() {
        return this.total;
    }

    public long totalInBytes() {
        return this.totalInBytes;
    }

    public String type() {
        return this.type;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("available");
        generator.write(this.available);
        generator.writeKey("available_in_bytes");
        generator.write(this.availableInBytes);
        generator.writeKey("disk_queue");
        generator.write(this.diskQueue);
        generator.writeKey("disk_reads");
        generator.write(this.diskReads);
        generator.writeKey("disk_read_size");
        generator.write(this.diskReadSize);
        generator.writeKey("disk_read_size_in_bytes");
        generator.write(this.diskReadSizeInBytes);
        generator.writeKey("disk_writes");
        generator.write(this.diskWrites);
        generator.writeKey("disk_write_size");
        generator.write(this.diskWriteSize);
        generator.writeKey("disk_write_size_in_bytes");
        generator.write(this.diskWriteSizeInBytes);
        generator.writeKey("free");
        generator.write(this.free);
        generator.writeKey("free_in_bytes");
        generator.write(this.freeInBytes);
        generator.writeKey("mount");
        generator.write(this.mount);
        generator.writeKey("path");
        generator.write(this.path);
        generator.writeKey("total");
        generator.write(this.total);
        generator.writeKey("total_in_bytes");
        generator.write(this.totalInBytes);
        generator.writeKey("type");
        generator.write(this.type);
    }

    protected static void setupDataPathStatsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::available, JsonpDeserializer.stringDeserializer(), "available", new String[0]);
        op.add(Builder::availableInBytes, JsonpDeserializer.longDeserializer(), "available_in_bytes", new String[0]);
        op.add(Builder::diskQueue, JsonpDeserializer.stringDeserializer(), "disk_queue", new String[0]);
        op.add(Builder::diskReads, JsonpDeserializer.longDeserializer(), "disk_reads", new String[0]);
        op.add(Builder::diskReadSize, JsonpDeserializer.stringDeserializer(), "disk_read_size", new String[0]);
        op.add(Builder::diskReadSizeInBytes, JsonpDeserializer.longDeserializer(), "disk_read_size_in_bytes", new String[0]);
        op.add(Builder::diskWrites, JsonpDeserializer.longDeserializer(), "disk_writes", new String[0]);
        op.add(Builder::diskWriteSize, JsonpDeserializer.stringDeserializer(), "disk_write_size", new String[0]);
        op.add(Builder::diskWriteSizeInBytes, JsonpDeserializer.longDeserializer(), "disk_write_size_in_bytes", new String[0]);
        op.add(Builder::free, JsonpDeserializer.stringDeserializer(), "free", new String[0]);
        op.add(Builder::freeInBytes, JsonpDeserializer.longDeserializer(), "free_in_bytes", new String[0]);
        op.add(Builder::mount, JsonpDeserializer.stringDeserializer(), "mount", new String[0]);
        op.add(Builder::path, JsonpDeserializer.stringDeserializer(), "path", new String[0]);
        op.add(Builder::total, JsonpDeserializer.stringDeserializer(), "total", new String[0]);
        op.add(Builder::totalInBytes, JsonpDeserializer.longDeserializer(), "total_in_bytes", new String[0]);
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "type", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<DataPathStats> {
        private String available;
        private Long availableInBytes;
        private String diskQueue;
        private Long diskReads;
        private String diskReadSize;
        private Long diskReadSizeInBytes;
        private Long diskWrites;
        private String diskWriteSize;
        private Long diskWriteSizeInBytes;
        private String free;
        private Long freeInBytes;
        private String mount;
        private String path;
        private String total;
        private Long totalInBytes;
        private String type;

        public Builder available(String value) {
            this.available = value;
            return this;
        }

        public Builder availableInBytes(long value) {
            this.availableInBytes = value;
            return this;
        }

        public Builder diskQueue(String value) {
            this.diskQueue = value;
            return this;
        }

        public Builder diskReads(long value) {
            this.diskReads = value;
            return this;
        }

        public Builder diskReadSize(String value) {
            this.diskReadSize = value;
            return this;
        }

        public Builder diskReadSizeInBytes(long value) {
            this.diskReadSizeInBytes = value;
            return this;
        }

        public Builder diskWrites(long value) {
            this.diskWrites = value;
            return this;
        }

        public Builder diskWriteSize(String value) {
            this.diskWriteSize = value;
            return this;
        }

        public Builder diskWriteSizeInBytes(long value) {
            this.diskWriteSizeInBytes = value;
            return this;
        }

        public Builder free(String value) {
            this.free = value;
            return this;
        }

        public Builder freeInBytes(long value) {
            this.freeInBytes = value;
            return this;
        }

        public Builder mount(String value) {
            this.mount = value;
            return this;
        }

        public Builder path(String value) {
            this.path = value;
            return this;
        }

        public Builder total(String value) {
            this.total = value;
            return this;
        }

        public Builder totalInBytes(long value) {
            this.totalInBytes = value;
            return this;
        }

        public Builder type(String value) {
            this.type = value;
            return this;
        }

        @Override
        public DataPathStats build() {
            return new DataPathStats(this);
        }
    }
}

