/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml.put_trained_model;

import co.elastic.clients.elasticsearch.ml.put_trained_model.FrequencyEncodingPreprocessor;
import co.elastic.clients.elasticsearch.ml.put_trained_model.OneHotEncodingPreprocessor;
import co.elastic.clients.elasticsearch.ml.put_trained_model.PreprocessorVariant;
import co.elastic.clients.elasticsearch.ml.put_trained_model.TargetMeanEncodingPreprocessor;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public class Preprocessor
implements TaggedUnion<Object>,
JsonpSerializable {
    public static final String FREQUENCY_ENCODING = "frequency_encoding";
    public static final String ONE_HOT_ENCODING = "one_hot_encoding";
    public static final String TARGET_MEAN_ENCODING = "target_mean_encoding";
    private final String _type;
    private final Object _value;
    public static final JsonpDeserializer<Preprocessor> _DESERIALIZER = JsonpDeserializer.lazy(Builder::new, Preprocessor::setupPreprocessorDeserializer, Builder::build);

    @Override
    public String _type() {
        return this._type;
    }

    @Override
    public Object _get() {
        return this._value;
    }

    public Preprocessor(PreprocessorVariant value) {
        this._type = Objects.requireNonNull(value._variantType(), "variant type");
        this._value = Objects.requireNonNull(value, "variant value");
    }

    private Preprocessor(Builder builder) {
        this._type = Objects.requireNonNull(builder._type, "variant type");
        this._value = Objects.requireNonNull(builder._value, "variant value");
    }

    public Preprocessor(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public FrequencyEncodingPreprocessor frequencyEncoding() {
        return (FrequencyEncodingPreprocessor)TaggedUnionUtils.get(this, FREQUENCY_ENCODING);
    }

    public OneHotEncodingPreprocessor oneHotEncoding() {
        return (OneHotEncodingPreprocessor)TaggedUnionUtils.get(this, ONE_HOT_ENCODING);
    }

    public TargetMeanEncodingPreprocessor targetMeanEncoding() {
        return (TargetMeanEncodingPreprocessor)TaggedUnionUtils.get(this, TARGET_MEAN_ENCODING);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        generator.writeKey(this._type);
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupPreprocessorDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::frequencyEncoding, FrequencyEncodingPreprocessor._DESERIALIZER, FREQUENCY_ENCODING, new String[0]);
        op.add(Builder::oneHotEncoding, OneHotEncodingPreprocessor._DESERIALIZER, ONE_HOT_ENCODING, new String[0]);
        op.add(Builder::targetMeanEncoding, TargetMeanEncodingPreprocessor._DESERIALIZER, TARGET_MEAN_ENCODING, new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<Preprocessor> {
        private String _type;
        private Object _value;

        public Builder frequencyEncoding(FrequencyEncodingPreprocessor v) {
            this._type = Preprocessor.FREQUENCY_ENCODING;
            this._value = v;
            return this;
        }

        public Builder frequencyEncoding(Function<FrequencyEncodingPreprocessor.Builder, ObjectBuilder<FrequencyEncodingPreprocessor>> f) {
            return this.frequencyEncoding(f.apply(new FrequencyEncodingPreprocessor.Builder()).build());
        }

        public Builder oneHotEncoding(OneHotEncodingPreprocessor v) {
            this._type = Preprocessor.ONE_HOT_ENCODING;
            this._value = v;
            return this;
        }

        public Builder oneHotEncoding(Function<OneHotEncodingPreprocessor.Builder, ObjectBuilder<OneHotEncodingPreprocessor>> f) {
            return this.oneHotEncoding(f.apply(new OneHotEncodingPreprocessor.Builder()).build());
        }

        public Builder targetMeanEncoding(TargetMeanEncodingPreprocessor v) {
            this._type = Preprocessor.TARGET_MEAN_ENCODING;
            this._value = v;
            return this;
        }

        public Builder targetMeanEncoding(Function<TargetMeanEncodingPreprocessor.Builder, ObjectBuilder<TargetMeanEncodingPreprocessor>> f) {
            return this.targetMeanEncoding(f.apply(new TargetMeanEncodingPreprocessor.Builder()).build());
        }

        @Override
        public Preprocessor build() {
            return new Preprocessor(this);
        }
    }
}

