/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml.preview_data_frame_analytics;

import co.elastic.clients.elasticsearch.ml.DataframeAnalysis;
import co.elastic.clients.elasticsearch.ml.DataframeAnalyticsSource;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class DataframePreviewConfig
implements JsonpSerializable {
    private final DataframeAnalyticsSource source;
    private final DataframeAnalysis analysis;
    @Nullable
    private final String modelMemoryLimit;
    @Nullable
    private final Integer maxNumThreads;
    @Nullable
    private final JsonValue analyzedFields;
    public static final JsonpDeserializer<DataframePreviewConfig> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DataframePreviewConfig::setupDataframePreviewConfigDeserializer, Builder::build);

    public DataframePreviewConfig(Builder builder) {
        this.source = Objects.requireNonNull(builder.source, "source");
        this.analysis = Objects.requireNonNull(builder.analysis, "analysis");
        this.modelMemoryLimit = builder.modelMemoryLimit;
        this.maxNumThreads = builder.maxNumThreads;
        this.analyzedFields = builder.analyzedFields;
    }

    public DataframePreviewConfig(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public DataframeAnalyticsSource source() {
        return this.source;
    }

    public DataframeAnalysis analysis() {
        return this.analysis;
    }

    @Nullable
    public String modelMemoryLimit() {
        return this.modelMemoryLimit;
    }

    @Nullable
    public Integer maxNumThreads() {
        return this.maxNumThreads;
    }

    @Nullable
    public JsonValue analyzedFields() {
        return this.analyzedFields;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("source");
        this.source.serialize(generator, mapper);
        generator.writeKey("analysis");
        this.analysis.serialize(generator, mapper);
        if (this.modelMemoryLimit != null) {
            generator.writeKey("model_memory_limit");
            generator.write(this.modelMemoryLimit);
        }
        if (this.maxNumThreads != null) {
            generator.writeKey("max_num_threads");
            generator.write(this.maxNumThreads.intValue());
        }
        if (this.analyzedFields != null) {
            generator.writeKey("analyzed_fields");
            generator.write(this.analyzedFields);
        }
    }

    protected static void setupDataframePreviewConfigDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::source, DataframeAnalyticsSource._DESERIALIZER, "source", new String[0]);
        op.add(Builder::analysis, DataframeAnalysis._DESERIALIZER, "analysis", new String[0]);
        op.add(Builder::modelMemoryLimit, JsonpDeserializer.stringDeserializer(), "model_memory_limit", new String[0]);
        op.add(Builder::maxNumThreads, JsonpDeserializer.integerDeserializer(), "max_num_threads", new String[0]);
        op.add(Builder::analyzedFields, JsonpDeserializer.jsonValueDeserializer(), "analyzed_fields", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<DataframePreviewConfig> {
        private DataframeAnalyticsSource source;
        private DataframeAnalysis analysis;
        @Nullable
        private String modelMemoryLimit;
        @Nullable
        private Integer maxNumThreads;
        @Nullable
        private JsonValue analyzedFields;

        public Builder source(DataframeAnalyticsSource value) {
            this.source = value;
            return this;
        }

        public Builder source(Function<DataframeAnalyticsSource.Builder, ObjectBuilder<DataframeAnalyticsSource>> fn) {
            return this.source(fn.apply(new DataframeAnalyticsSource.Builder()).build());
        }

        public Builder analysis(DataframeAnalysis value) {
            this.analysis = value;
            return this;
        }

        public Builder analysis(Function<DataframeAnalysis.Builder, ObjectBuilder<DataframeAnalysis>> fn) {
            return this.analysis(fn.apply(new DataframeAnalysis.Builder()).build());
        }

        public Builder modelMemoryLimit(@Nullable String value) {
            this.modelMemoryLimit = value;
            return this;
        }

        public Builder maxNumThreads(@Nullable Integer value) {
            this.maxNumThreads = value;
            return this;
        }

        public Builder analyzedFields(@Nullable JsonValue value) {
            this.analyzedFields = value;
            return this;
        }

        @Override
        public DataframePreviewConfig build() {
            return new DataframePreviewConfig(this);
        }
    }
}

