/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.AnalysisConfigRead;
import co.elastic.clients.elasticsearch.ml.AnalysisLimits;
import co.elastic.clients.elasticsearch.ml.DataDescription;
import co.elastic.clients.elasticsearch.ml.Datafeed;
import co.elastic.clients.elasticsearch.ml.ModelPlotConfig;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class UpdateJobResponse
implements JsonpSerializable {
    private final boolean allowLazyOpen;
    private final AnalysisConfigRead analysisConfig;
    private final AnalysisLimits analysisLimits;
    @Nullable
    private final String backgroundPersistInterval;
    private final String createTime;
    @Nullable
    private final String finishedTime;
    @Nullable
    private final Map<String, String> customSettings;
    private final long dailyModelSnapshotRetentionAfterDays;
    private final DataDescription dataDescription;
    @Nullable
    private final Datafeed datafeedConfig;
    @Nullable
    private final String description;
    @Nullable
    private final List<String> groups;
    private final String jobId;
    private final String jobType;
    private final String jobVersion;
    @Nullable
    private final ModelPlotConfig modelPlotConfig;
    @Nullable
    private final String modelSnapshotId;
    private final long modelSnapshotRetentionDays;
    @Nullable
    private final Long renormalizationWindowDays;
    private final String resultsIndexName;
    @Nullable
    private final Long resultsRetentionDays;
    public static final JsonpDeserializer<UpdateJobResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, UpdateJobResponse::setupUpdateJobResponseDeserializer, Builder::build);

    public UpdateJobResponse(Builder builder) {
        this.allowLazyOpen = Objects.requireNonNull(builder.allowLazyOpen, "allow_lazy_open");
        this.analysisConfig = Objects.requireNonNull(builder.analysisConfig, "analysis_config");
        this.analysisLimits = Objects.requireNonNull(builder.analysisLimits, "analysis_limits");
        this.backgroundPersistInterval = builder.backgroundPersistInterval;
        this.createTime = Objects.requireNonNull(builder.createTime, "create_time");
        this.finishedTime = builder.finishedTime;
        this.customSettings = ModelTypeHelper.unmodifiable(builder.customSettings);
        this.dailyModelSnapshotRetentionAfterDays = Objects.requireNonNull(builder.dailyModelSnapshotRetentionAfterDays, "daily_model_snapshot_retention_after_days");
        this.dataDescription = Objects.requireNonNull(builder.dataDescription, "data_description");
        this.datafeedConfig = builder.datafeedConfig;
        this.description = builder.description;
        this.groups = ModelTypeHelper.unmodifiable(builder.groups);
        this.jobId = Objects.requireNonNull(builder.jobId, "job_id");
        this.jobType = Objects.requireNonNull(builder.jobType, "job_type");
        this.jobVersion = Objects.requireNonNull(builder.jobVersion, "job_version");
        this.modelPlotConfig = builder.modelPlotConfig;
        this.modelSnapshotId = builder.modelSnapshotId;
        this.modelSnapshotRetentionDays = Objects.requireNonNull(builder.modelSnapshotRetentionDays, "model_snapshot_retention_days");
        this.renormalizationWindowDays = builder.renormalizationWindowDays;
        this.resultsIndexName = Objects.requireNonNull(builder.resultsIndexName, "results_index_name");
        this.resultsRetentionDays = builder.resultsRetentionDays;
    }

    public UpdateJobResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public boolean allowLazyOpen() {
        return this.allowLazyOpen;
    }

    public AnalysisConfigRead analysisConfig() {
        return this.analysisConfig;
    }

    public AnalysisLimits analysisLimits() {
        return this.analysisLimits;
    }

    @Nullable
    public String backgroundPersistInterval() {
        return this.backgroundPersistInterval;
    }

    public String createTime() {
        return this.createTime;
    }

    @Nullable
    public String finishedTime() {
        return this.finishedTime;
    }

    @Nullable
    public Map<String, String> customSettings() {
        return this.customSettings;
    }

    public long dailyModelSnapshotRetentionAfterDays() {
        return this.dailyModelSnapshotRetentionAfterDays;
    }

    public DataDescription dataDescription() {
        return this.dataDescription;
    }

    @Nullable
    public Datafeed datafeedConfig() {
        return this.datafeedConfig;
    }

    @Nullable
    public String description() {
        return this.description;
    }

    @Nullable
    public List<String> groups() {
        return this.groups;
    }

    public String jobId() {
        return this.jobId;
    }

    public String jobType() {
        return this.jobType;
    }

    public String jobVersion() {
        return this.jobVersion;
    }

    @Nullable
    public ModelPlotConfig modelPlotConfig() {
        return this.modelPlotConfig;
    }

    @Nullable
    public String modelSnapshotId() {
        return this.modelSnapshotId;
    }

    public long modelSnapshotRetentionDays() {
        return this.modelSnapshotRetentionDays;
    }

    @Nullable
    public Long renormalizationWindowDays() {
        return this.renormalizationWindowDays;
    }

    public String resultsIndexName() {
        return this.resultsIndexName;
    }

    @Nullable
    public Long resultsRetentionDays() {
        return this.resultsRetentionDays;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("allow_lazy_open");
        generator.write(this.allowLazyOpen);
        generator.writeKey("analysis_config");
        this.analysisConfig.serialize(generator, mapper);
        generator.writeKey("analysis_limits");
        this.analysisLimits.serialize(generator, mapper);
        if (this.backgroundPersistInterval != null) {
            generator.writeKey("background_persist_interval");
            generator.write(this.backgroundPersistInterval);
        }
        generator.writeKey("create_time");
        generator.write(this.createTime);
        if (this.finishedTime != null) {
            generator.writeKey("finished_time");
            generator.write(this.finishedTime);
        }
        if (this.customSettings != null) {
            generator.writeKey("custom_settings");
            generator.writeStartObject();
            for (Map.Entry<String, String> entry : this.customSettings.entrySet()) {
                generator.writeKey(entry.getKey());
                generator.write(entry.getValue());
            }
            generator.writeEnd();
        }
        generator.writeKey("daily_model_snapshot_retention_after_days");
        generator.write(this.dailyModelSnapshotRetentionAfterDays);
        generator.writeKey("data_description");
        this.dataDescription.serialize(generator, mapper);
        if (this.datafeedConfig != null) {
            generator.writeKey("datafeed_config");
            this.datafeedConfig.serialize(generator, mapper);
        }
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        if (this.groups != null) {
            generator.writeKey("groups");
            generator.writeStartArray();
            for (String string : this.groups) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        generator.writeKey("job_id");
        generator.write(this.jobId);
        generator.writeKey("job_type");
        generator.write(this.jobType);
        generator.writeKey("job_version");
        generator.write(this.jobVersion);
        if (this.modelPlotConfig != null) {
            generator.writeKey("model_plot_config");
            this.modelPlotConfig.serialize(generator, mapper);
        }
        if (this.modelSnapshotId != null) {
            generator.writeKey("model_snapshot_id");
            generator.write(this.modelSnapshotId);
        }
        generator.writeKey("model_snapshot_retention_days");
        generator.write(this.modelSnapshotRetentionDays);
        if (this.renormalizationWindowDays != null) {
            generator.writeKey("renormalization_window_days");
            generator.write(this.renormalizationWindowDays.longValue());
        }
        generator.writeKey("results_index_name");
        generator.write(this.resultsIndexName);
        if (this.resultsRetentionDays != null) {
            generator.writeKey("results_retention_days");
            generator.write(this.resultsRetentionDays.longValue());
        }
    }

    protected static void setupUpdateJobResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::allowLazyOpen, JsonpDeserializer.booleanDeserializer(), "allow_lazy_open", new String[0]);
        op.add(Builder::analysisConfig, AnalysisConfigRead._DESERIALIZER, "analysis_config", new String[0]);
        op.add(Builder::analysisLimits, AnalysisLimits._DESERIALIZER, "analysis_limits", new String[0]);
        op.add(Builder::backgroundPersistInterval, JsonpDeserializer.stringDeserializer(), "background_persist_interval", new String[0]);
        op.add(Builder::createTime, JsonpDeserializer.stringDeserializer(), "create_time", new String[0]);
        op.add(Builder::finishedTime, JsonpDeserializer.stringDeserializer(), "finished_time", new String[0]);
        op.add(Builder::customSettings, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "custom_settings", new String[0]);
        op.add(Builder::dailyModelSnapshotRetentionAfterDays, JsonpDeserializer.longDeserializer(), "daily_model_snapshot_retention_after_days", new String[0]);
        op.add(Builder::dataDescription, DataDescription._DESERIALIZER, "data_description", new String[0]);
        op.add(Builder::datafeedConfig, Datafeed._DESERIALIZER, "datafeed_config", new String[0]);
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description", new String[0]);
        op.add(Builder::groups, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "groups", new String[0]);
        op.add(Builder::jobId, JsonpDeserializer.stringDeserializer(), "job_id", new String[0]);
        op.add(Builder::jobType, JsonpDeserializer.stringDeserializer(), "job_type", new String[0]);
        op.add(Builder::jobVersion, JsonpDeserializer.stringDeserializer(), "job_version", new String[0]);
        op.add(Builder::modelPlotConfig, ModelPlotConfig._DESERIALIZER, "model_plot_config", new String[0]);
        op.add(Builder::modelSnapshotId, JsonpDeserializer.stringDeserializer(), "model_snapshot_id", new String[0]);
        op.add(Builder::modelSnapshotRetentionDays, JsonpDeserializer.longDeserializer(), "model_snapshot_retention_days", new String[0]);
        op.add(Builder::renormalizationWindowDays, JsonpDeserializer.longDeserializer(), "renormalization_window_days", new String[0]);
        op.add(Builder::resultsIndexName, JsonpDeserializer.stringDeserializer(), "results_index_name", new String[0]);
        op.add(Builder::resultsRetentionDays, JsonpDeserializer.longDeserializer(), "results_retention_days", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<UpdateJobResponse> {
        private Boolean allowLazyOpen;
        private AnalysisConfigRead analysisConfig;
        private AnalysisLimits analysisLimits;
        @Nullable
        private String backgroundPersistInterval;
        private String createTime;
        @Nullable
        private String finishedTime;
        @Nullable
        private Map<String, String> customSettings;
        private Long dailyModelSnapshotRetentionAfterDays;
        private DataDescription dataDescription;
        @Nullable
        private Datafeed datafeedConfig;
        @Nullable
        private String description;
        @Nullable
        private List<String> groups;
        private String jobId;
        private String jobType;
        private String jobVersion;
        @Nullable
        private ModelPlotConfig modelPlotConfig;
        @Nullable
        private String modelSnapshotId;
        private Long modelSnapshotRetentionDays;
        @Nullable
        private Long renormalizationWindowDays;
        private String resultsIndexName;
        @Nullable
        private Long resultsRetentionDays;

        public Builder allowLazyOpen(boolean value) {
            this.allowLazyOpen = value;
            return this;
        }

        public Builder analysisConfig(AnalysisConfigRead value) {
            this.analysisConfig = value;
            return this;
        }

        public Builder analysisConfig(Function<AnalysisConfigRead.Builder, ObjectBuilder<AnalysisConfigRead>> fn) {
            return this.analysisConfig(fn.apply(new AnalysisConfigRead.Builder()).build());
        }

        public Builder analysisLimits(AnalysisLimits value) {
            this.analysisLimits = value;
            return this;
        }

        public Builder analysisLimits(Function<AnalysisLimits.Builder, ObjectBuilder<AnalysisLimits>> fn) {
            return this.analysisLimits(fn.apply(new AnalysisLimits.Builder()).build());
        }

        public Builder backgroundPersistInterval(@Nullable String value) {
            this.backgroundPersistInterval = value;
            return this;
        }

        public Builder createTime(String value) {
            this.createTime = value;
            return this;
        }

        public Builder finishedTime(@Nullable String value) {
            this.finishedTime = value;
            return this;
        }

        public Builder customSettings(@Nullable Map<String, String> value) {
            this.customSettings = value;
            return this;
        }

        public Builder putCustomSettings(String key, String value) {
            if (this.customSettings == null) {
                this.customSettings = new HashMap<String, String>();
            }
            this.customSettings.put(key, value);
            return this;
        }

        public Builder dailyModelSnapshotRetentionAfterDays(long value) {
            this.dailyModelSnapshotRetentionAfterDays = value;
            return this;
        }

        public Builder dataDescription(DataDescription value) {
            this.dataDescription = value;
            return this;
        }

        public Builder dataDescription(Function<DataDescription.Builder, ObjectBuilder<DataDescription>> fn) {
            return this.dataDescription(fn.apply(new DataDescription.Builder()).build());
        }

        public Builder datafeedConfig(@Nullable Datafeed value) {
            this.datafeedConfig = value;
            return this;
        }

        public Builder datafeedConfig(Function<Datafeed.Builder, ObjectBuilder<Datafeed>> fn) {
            return this.datafeedConfig(fn.apply(new Datafeed.Builder()).build());
        }

        public Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        public Builder groups(@Nullable List<String> value) {
            this.groups = value;
            return this;
        }

        public Builder groups(String ... value) {
            this.groups = Arrays.asList(value);
            return this;
        }

        public Builder addGroups(String value) {
            if (this.groups == null) {
                this.groups = new ArrayList<String>();
            }
            this.groups.add(value);
            return this;
        }

        public Builder jobId(String value) {
            this.jobId = value;
            return this;
        }

        public Builder jobType(String value) {
            this.jobType = value;
            return this;
        }

        public Builder jobVersion(String value) {
            this.jobVersion = value;
            return this;
        }

        public Builder modelPlotConfig(@Nullable ModelPlotConfig value) {
            this.modelPlotConfig = value;
            return this;
        }

        public Builder modelPlotConfig(Function<ModelPlotConfig.Builder, ObjectBuilder<ModelPlotConfig>> fn) {
            return this.modelPlotConfig(fn.apply(new ModelPlotConfig.Builder()).build());
        }

        public Builder modelSnapshotId(@Nullable String value) {
            this.modelSnapshotId = value;
            return this;
        }

        public Builder modelSnapshotRetentionDays(long value) {
            this.modelSnapshotRetentionDays = value;
            return this;
        }

        public Builder renormalizationWindowDays(@Nullable Long value) {
            this.renormalizationWindowDays = value;
            return this;
        }

        public Builder resultsIndexName(String value) {
            this.resultsIndexName = value;
            return this;
        }

        public Builder resultsRetentionDays(@Nullable Long value) {
            this.resultsRetentionDays = value;
            return this;
        }

        @Override
        public UpdateJobResponse build() {
            return new UpdateJobResponse(this);
        }
    }
}

