/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.UpdateDataFrameAnalyticsResponse;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class UpdateDataFrameAnalyticsRequest
extends RequestBase
implements JsonpSerializable {
    private final String id;
    @Nullable
    private final String description;
    @Nullable
    private final String modelMemoryLimit;
    @Nullable
    private final Integer maxNumThreads;
    @Nullable
    private final Boolean allowLazyStart;
    public static final JsonpDeserializer<UpdateDataFrameAnalyticsRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, UpdateDataFrameAnalyticsRequest::setupUpdateDataFrameAnalyticsRequestDeserializer, Builder::build);
    public static final Endpoint<UpdateDataFrameAnalyticsRequest, UpdateDataFrameAnalyticsResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<UpdateDataFrameAnalyticsRequest, UpdateDataFrameAnalyticsResponse>(request -> "POST", request -> {
        boolean _id = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/data_frame");
            buf.append("/analytics");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.id, buf);
            buf.append("/_update");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, UpdateDataFrameAnalyticsResponse._DESERIALIZER);

    public UpdateDataFrameAnalyticsRequest(Builder builder) {
        this.id = Objects.requireNonNull(builder.id, "id");
        this.description = builder.description;
        this.modelMemoryLimit = builder.modelMemoryLimit;
        this.maxNumThreads = builder.maxNumThreads;
        this.allowLazyStart = builder.allowLazyStart;
    }

    public UpdateDataFrameAnalyticsRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String id() {
        return this.id;
    }

    @Nullable
    public String description() {
        return this.description;
    }

    @Nullable
    public String modelMemoryLimit() {
        return this.modelMemoryLimit;
    }

    @Nullable
    public Integer maxNumThreads() {
        return this.maxNumThreads;
    }

    @Nullable
    public Boolean allowLazyStart() {
        return this.allowLazyStart;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        if (this.modelMemoryLimit != null) {
            generator.writeKey("model_memory_limit");
            generator.write(this.modelMemoryLimit);
        }
        if (this.maxNumThreads != null) {
            generator.writeKey("max_num_threads");
            generator.write(this.maxNumThreads.intValue());
        }
        if (this.allowLazyStart != null) {
            generator.writeKey("allow_lazy_start");
            generator.write(this.allowLazyStart.booleanValue());
        }
    }

    protected static void setupUpdateDataFrameAnalyticsRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description", new String[0]);
        op.add(Builder::modelMemoryLimit, JsonpDeserializer.stringDeserializer(), "model_memory_limit", new String[0]);
        op.add(Builder::maxNumThreads, JsonpDeserializer.integerDeserializer(), "max_num_threads", new String[0]);
        op.add(Builder::allowLazyStart, JsonpDeserializer.booleanDeserializer(), "allow_lazy_start", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<UpdateDataFrameAnalyticsRequest> {
        private String id;
        @Nullable
        private String description;
        @Nullable
        private String modelMemoryLimit;
        @Nullable
        private Integer maxNumThreads;
        @Nullable
        private Boolean allowLazyStart;

        public Builder id(String value) {
            this.id = value;
            return this;
        }

        public Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        public Builder modelMemoryLimit(@Nullable String value) {
            this.modelMemoryLimit = value;
            return this;
        }

        public Builder maxNumThreads(@Nullable Integer value) {
            this.maxNumThreads = value;
            return this;
        }

        public Builder allowLazyStart(@Nullable Boolean value) {
            this.allowLazyStart = value;
            return this;
        }

        @Override
        public UpdateDataFrameAnalyticsRequest build() {
            return new UpdateDataFrameAnalyticsRequest(this);
        }
    }
}

