/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class PartitionScore
implements JsonpSerializable {
    private final double initialRecordScore;
    private final String partitionFieldName;
    private final String partitionFieldValue;
    private final double probability;
    private final double recordScore;
    public static final JsonpDeserializer<PartitionScore> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PartitionScore::setupPartitionScoreDeserializer, Builder::build);

    public PartitionScore(Builder builder) {
        this.initialRecordScore = Objects.requireNonNull(builder.initialRecordScore, "initial_record_score");
        this.partitionFieldName = Objects.requireNonNull(builder.partitionFieldName, "partition_field_name");
        this.partitionFieldValue = Objects.requireNonNull(builder.partitionFieldValue, "partition_field_value");
        this.probability = Objects.requireNonNull(builder.probability, "probability");
        this.recordScore = Objects.requireNonNull(builder.recordScore, "record_score");
    }

    public PartitionScore(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public double initialRecordScore() {
        return this.initialRecordScore;
    }

    public String partitionFieldName() {
        return this.partitionFieldName;
    }

    public String partitionFieldValue() {
        return this.partitionFieldValue;
    }

    public double probability() {
        return this.probability;
    }

    public double recordScore() {
        return this.recordScore;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("initial_record_score");
        generator.write(this.initialRecordScore);
        generator.writeKey("partition_field_name");
        generator.write(this.partitionFieldName);
        generator.writeKey("partition_field_value");
        generator.write(this.partitionFieldValue);
        generator.writeKey("probability");
        generator.write(this.probability);
        generator.writeKey("record_score");
        generator.write(this.recordScore);
    }

    protected static void setupPartitionScoreDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::initialRecordScore, JsonpDeserializer.doubleDeserializer(), "initial_record_score", new String[0]);
        op.add(Builder::partitionFieldName, JsonpDeserializer.stringDeserializer(), "partition_field_name", new String[0]);
        op.add(Builder::partitionFieldValue, JsonpDeserializer.stringDeserializer(), "partition_field_value", new String[0]);
        op.add(Builder::probability, JsonpDeserializer.doubleDeserializer(), "probability", new String[0]);
        op.add(Builder::recordScore, JsonpDeserializer.doubleDeserializer(), "record_score", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<PartitionScore> {
        private Double initialRecordScore;
        private String partitionFieldName;
        private String partitionFieldValue;
        private Double probability;
        private Double recordScore;

        public Builder initialRecordScore(double value) {
            this.initialRecordScore = value;
            return this;
        }

        public Builder partitionFieldName(String value) {
            this.partitionFieldName = value;
            return this;
        }

        public Builder partitionFieldValue(String value) {
            this.partitionFieldValue = value;
            return this;
        }

        public Builder probability(double value) {
            this.probability = value;
            return this;
        }

        public Builder recordScore(double value) {
            this.recordScore = value;
            return this;
        }

        @Override
        public PartitionScore build() {
            return new PartitionScore(this);
        }
    }
}

