/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.TrainedModelStats;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class GetTrainedModelsStatsResponse
implements JsonpSerializable {
    private final int count;
    private final List<TrainedModelStats> trainedModelStats;
    public static final JsonpDeserializer<GetTrainedModelsStatsResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetTrainedModelsStatsResponse::setupGetTrainedModelsStatsResponseDeserializer, Builder::build);

    public GetTrainedModelsStatsResponse(Builder builder) {
        this.count = Objects.requireNonNull(builder.count, "count");
        this.trainedModelStats = ModelTypeHelper.unmodifiableNonNull(builder.trainedModelStats, "trained_model_stats");
    }

    public GetTrainedModelsStatsResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public int count() {
        return this.count;
    }

    public List<TrainedModelStats> trainedModelStats() {
        return this.trainedModelStats;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("count");
        generator.write(this.count);
        generator.writeKey("trained_model_stats");
        generator.writeStartArray();
        for (TrainedModelStats item0 : this.trainedModelStats) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupGetTrainedModelsStatsResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::count, JsonpDeserializer.integerDeserializer(), "count", new String[0]);
        op.add(Builder::trainedModelStats, JsonpDeserializer.arrayDeserializer(TrainedModelStats._DESERIALIZER), "trained_model_stats", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<GetTrainedModelsStatsResponse> {
        private Integer count;
        private List<TrainedModelStats> trainedModelStats;

        public Builder count(int value) {
            this.count = value;
            return this;
        }

        public Builder trainedModelStats(List<TrainedModelStats> value) {
            this.trainedModelStats = value;
            return this;
        }

        public Builder trainedModelStats(TrainedModelStats ... value) {
            this.trainedModelStats = Arrays.asList(value);
            return this;
        }

        public Builder addTrainedModelStats(TrainedModelStats value) {
            if (this.trainedModelStats == null) {
                this.trainedModelStats = new ArrayList<TrainedModelStats>();
            }
            this.trainedModelStats.add(value);
            return this;
        }

        public Builder trainedModelStats(Function<TrainedModelStats.Builder, ObjectBuilder<TrainedModelStats>> fn) {
            return this.trainedModelStats(fn.apply(new TrainedModelStats.Builder()).build());
        }

        public Builder addTrainedModelStats(Function<TrainedModelStats.Builder, ObjectBuilder<TrainedModelStats>> fn) {
            return this.addTrainedModelStats(fn.apply(new TrainedModelStats.Builder()).build());
        }

        @Override
        public GetTrainedModelsStatsResponse build() {
            return new GetTrainedModelsStatsResponse(this);
        }
    }
}

