/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.TrainedModelConfig;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class GetTrainedModelsResponse
implements JsonpSerializable {
    private final int count;
    private final List<TrainedModelConfig> trainedModelConfigs;
    public static final JsonpDeserializer<GetTrainedModelsResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetTrainedModelsResponse::setupGetTrainedModelsResponseDeserializer, Builder::build);

    public GetTrainedModelsResponse(Builder builder) {
        this.count = Objects.requireNonNull(builder.count, "count");
        this.trainedModelConfigs = ModelTypeHelper.unmodifiableNonNull(builder.trainedModelConfigs, "trained_model_configs");
    }

    public GetTrainedModelsResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public int count() {
        return this.count;
    }

    public List<TrainedModelConfig> trainedModelConfigs() {
        return this.trainedModelConfigs;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("count");
        generator.write(this.count);
        generator.writeKey("trained_model_configs");
        generator.writeStartArray();
        for (TrainedModelConfig item0 : this.trainedModelConfigs) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupGetTrainedModelsResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::count, JsonpDeserializer.integerDeserializer(), "count", new String[0]);
        op.add(Builder::trainedModelConfigs, JsonpDeserializer.arrayDeserializer(TrainedModelConfig._DESERIALIZER), "trained_model_configs", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<GetTrainedModelsResponse> {
        private Integer count;
        private List<TrainedModelConfig> trainedModelConfigs;

        public Builder count(int value) {
            this.count = value;
            return this;
        }

        public Builder trainedModelConfigs(List<TrainedModelConfig> value) {
            this.trainedModelConfigs = value;
            return this;
        }

        public Builder trainedModelConfigs(TrainedModelConfig ... value) {
            this.trainedModelConfigs = Arrays.asList(value);
            return this;
        }

        public Builder addTrainedModelConfigs(TrainedModelConfig value) {
            if (this.trainedModelConfigs == null) {
                this.trainedModelConfigs = new ArrayList<TrainedModelConfig>();
            }
            this.trainedModelConfigs.add(value);
            return this;
        }

        public Builder trainedModelConfigs(Function<TrainedModelConfig.Builder, ObjectBuilder<TrainedModelConfig>> fn) {
            return this.trainedModelConfigs(fn.apply(new TrainedModelConfig.Builder()).build());
        }

        public Builder addTrainedModelConfigs(Function<TrainedModelConfig.Builder, ObjectBuilder<TrainedModelConfig>> fn) {
            return this.addTrainedModelConfigs(fn.apply(new TrainedModelConfig.Builder()).build());
        }

        @Override
        public GetTrainedModelsResponse build() {
            return new GetTrainedModelsResponse(this);
        }
    }
}

