/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.FlushJobResponse;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class FlushJobRequest
extends RequestBase
implements JsonpSerializable {
    private final String jobId;
    @Nullable
    private final String skipTime;
    @Nullable
    private final String advanceTime;
    @Nullable
    private final Boolean calcInterim;
    @Nullable
    private final String end;
    @Nullable
    private final String start;
    public static final JsonpDeserializer<FlushJobRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FlushJobRequest::setupFlushJobRequestDeserializer, Builder::build);
    public static final Endpoint<FlushJobRequest, FlushJobResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<FlushJobRequest, FlushJobResponse>(request -> "POST", request -> {
        boolean _jobId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/anomaly_detectors");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.jobId, buf);
            buf.append("/_flush");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.skipTime != null) {
            params.put("skip_time", request.skipTime);
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, FlushJobResponse._DESERIALIZER);

    public FlushJobRequest(Builder builder) {
        this.jobId = Objects.requireNonNull(builder.jobId, "job_id");
        this.skipTime = builder.skipTime;
        this.advanceTime = builder.advanceTime;
        this.calcInterim = builder.calcInterim;
        this.end = builder.end;
        this.start = builder.start;
    }

    public FlushJobRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String jobId() {
        return this.jobId;
    }

    @Nullable
    public String skipTime() {
        return this.skipTime;
    }

    @Nullable
    public String advanceTime() {
        return this.advanceTime;
    }

    @Nullable
    public Boolean calcInterim() {
        return this.calcInterim;
    }

    @Nullable
    public String end() {
        return this.end;
    }

    @Nullable
    public String start() {
        return this.start;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.advanceTime != null) {
            generator.writeKey("advance_time");
            generator.write(this.advanceTime);
        }
        if (this.calcInterim != null) {
            generator.writeKey("calc_interim");
            generator.write(this.calcInterim.booleanValue());
        }
        if (this.end != null) {
            generator.writeKey("end");
            generator.write(this.end);
        }
        if (this.start != null) {
            generator.writeKey("start");
            generator.write(this.start);
        }
    }

    protected static void setupFlushJobRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::advanceTime, JsonpDeserializer.stringDeserializer(), "advance_time", new String[0]);
        op.add(Builder::calcInterim, JsonpDeserializer.booleanDeserializer(), "calc_interim", new String[0]);
        op.add(Builder::end, JsonpDeserializer.stringDeserializer(), "end", new String[0]);
        op.add(Builder::start, JsonpDeserializer.stringDeserializer(), "start", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<FlushJobRequest> {
        private String jobId;
        @Nullable
        private String skipTime;
        @Nullable
        private String advanceTime;
        @Nullable
        private Boolean calcInterim;
        @Nullable
        private String end;
        @Nullable
        private String start;

        public Builder jobId(String value) {
            this.jobId = value;
            return this;
        }

        public Builder skipTime(@Nullable String value) {
            this.skipTime = value;
            return this;
        }

        public Builder advanceTime(@Nullable String value) {
            this.advanceTime = value;
            return this;
        }

        public Builder calcInterim(@Nullable Boolean value) {
            this.calcInterim = value;
            return this;
        }

        public Builder end(@Nullable String value) {
            this.end = value;
            return this;
        }

        public Builder start(@Nullable String value) {
            this.start = value;
            return this;
        }

        @Override
        public FlushJobRequest build() {
            return new FlushJobRequest(this);
        }
    }
}

