/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.DataframeEvaluationMetrics;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class DataframeEvaluationOutlierDetectionMetrics
extends DataframeEvaluationMetrics {
    @Nullable
    private final Map<String, JsonData> confusionMatrix;
    public static final JsonpDeserializer<DataframeEvaluationOutlierDetectionMetrics> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DataframeEvaluationOutlierDetectionMetrics::setupDataframeEvaluationOutlierDetectionMetricsDeserializer, Builder::build);

    public DataframeEvaluationOutlierDetectionMetrics(Builder builder) {
        super(builder);
        this.confusionMatrix = ModelTypeHelper.unmodifiable(builder.confusionMatrix);
    }

    public DataframeEvaluationOutlierDetectionMetrics(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public Map<String, JsonData> confusionMatrix() {
        return this.confusionMatrix;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.confusionMatrix != null) {
            generator.writeKey("confusion_matrix");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.confusionMatrix.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupDataframeEvaluationOutlierDetectionMetricsDeserializer(DelegatingDeserializer<Builder> op) {
        DataframeEvaluationMetrics.setupDataframeEvaluationMetricsDeserializer(op);
        op.add(Builder::confusionMatrix, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "confusion_matrix", new String[0]);
    }

    public static class Builder
    extends DataframeEvaluationMetrics.AbstractBuilder<Builder>
    implements ObjectBuilder<DataframeEvaluationOutlierDetectionMetrics> {
        @Nullable
        private Map<String, JsonData> confusionMatrix;

        public Builder confusionMatrix(@Nullable Map<String, JsonData> value) {
            this.confusionMatrix = value;
            return this;
        }

        public Builder putConfusionMatrix(String key, JsonData value) {
            if (this.confusionMatrix == null) {
                this.confusionMatrix = new HashMap<String, JsonData>();
            }
            this.confusionMatrix.put(key, value);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DataframeEvaluationOutlierDetectionMetrics build() {
            return new DataframeEvaluationOutlierDetectionMetrics(this);
        }
    }
}

