/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.DataframeEvaluationMetrics;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class DataframeEvaluationClassificationMetrics
extends DataframeEvaluationMetrics {
    @Nullable
    private final Map<String, JsonData> accuracy;
    @Nullable
    private final Map<String, JsonData> multiclassConfusionMatrix;
    public static final JsonpDeserializer<DataframeEvaluationClassificationMetrics> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DataframeEvaluationClassificationMetrics::setupDataframeEvaluationClassificationMetricsDeserializer, Builder::build);

    public DataframeEvaluationClassificationMetrics(Builder builder) {
        super(builder);
        this.accuracy = ModelTypeHelper.unmodifiable(builder.accuracy);
        this.multiclassConfusionMatrix = ModelTypeHelper.unmodifiable(builder.multiclassConfusionMatrix);
    }

    public DataframeEvaluationClassificationMetrics(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public Map<String, JsonData> accuracy() {
        return this.accuracy;
    }

    @Nullable
    public Map<String, JsonData> multiclassConfusionMatrix() {
        return this.multiclassConfusionMatrix;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.accuracy != null) {
            generator.writeKey("accuracy");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.accuracy.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.multiclassConfusionMatrix != null) {
            generator.writeKey("multiclass_confusion_matrix");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.multiclassConfusionMatrix.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupDataframeEvaluationClassificationMetricsDeserializer(DelegatingDeserializer<Builder> op) {
        DataframeEvaluationMetrics.setupDataframeEvaluationMetricsDeserializer(op);
        op.add(Builder::accuracy, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "accuracy", new String[0]);
        op.add(Builder::multiclassConfusionMatrix, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "multiclass_confusion_matrix", new String[0]);
    }

    public static class Builder
    extends DataframeEvaluationMetrics.AbstractBuilder<Builder>
    implements ObjectBuilder<DataframeEvaluationClassificationMetrics> {
        @Nullable
        private Map<String, JsonData> accuracy;
        @Nullable
        private Map<String, JsonData> multiclassConfusionMatrix;

        public Builder accuracy(@Nullable Map<String, JsonData> value) {
            this.accuracy = value;
            return this;
        }

        public Builder putAccuracy(String key, JsonData value) {
            if (this.accuracy == null) {
                this.accuracy = new HashMap<String, JsonData>();
            }
            this.accuracy.put(key, value);
            return this;
        }

        public Builder multiclassConfusionMatrix(@Nullable Map<String, JsonData> value) {
            this.multiclassConfusionMatrix = value;
            return this;
        }

        public Builder putMulticlassConfusionMatrix(String key, JsonData value) {
            if (this.multiclassConfusionMatrix == null) {
                this.multiclassConfusionMatrix = new HashMap<String, JsonData>();
            }
            this.multiclassConfusionMatrix.put(key, value);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DataframeEvaluationClassificationMetrics build() {
            return new DataframeEvaluationClassificationMetrics(this);
        }
    }
}

