/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.DataframeAnalyticsStatsHyperparameters;
import co.elastic.clients.elasticsearch.ml.DataframeAnalyticsStatsOutlierDetection;
import co.elastic.clients.elasticsearch.ml.DataframeAnalyticsStatsVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public class DataframeAnalyticsStats
implements TaggedUnion<Object>,
JsonpSerializable {
    public static final String CLASSIFICATION_STATS = "classification_stats";
    public static final String OUTLIER_DETECTION_STATS = "outlier_detection_stats";
    public static final String REGRESSION_STATS = "regression_stats";
    private final String _type;
    private final Object _value;
    public static final JsonpDeserializer<DataframeAnalyticsStats> _DESERIALIZER = JsonpDeserializer.lazy(Builder::new, DataframeAnalyticsStats::setupDataframeAnalyticsStatsDeserializer, Builder::build);

    @Override
    public String _type() {
        return this._type;
    }

    @Override
    public Object _get() {
        return this._value;
    }

    public DataframeAnalyticsStats(DataframeAnalyticsStatsVariant value) {
        this._type = Objects.requireNonNull(value._variantType(), "variant type");
        this._value = Objects.requireNonNull(value, "variant value");
    }

    private DataframeAnalyticsStats(Builder builder) {
        this._type = Objects.requireNonNull(builder._type, "variant type");
        this._value = Objects.requireNonNull(builder._value, "variant value");
    }

    public DataframeAnalyticsStats(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public DataframeAnalyticsStatsHyperparameters classificationStats() {
        return (DataframeAnalyticsStatsHyperparameters)TaggedUnionUtils.get(this, CLASSIFICATION_STATS);
    }

    public DataframeAnalyticsStatsOutlierDetection outlierDetectionStats() {
        return (DataframeAnalyticsStatsOutlierDetection)TaggedUnionUtils.get(this, OUTLIER_DETECTION_STATS);
    }

    public DataframeAnalyticsStatsHyperparameters regressionStats() {
        return (DataframeAnalyticsStatsHyperparameters)TaggedUnionUtils.get(this, REGRESSION_STATS);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        generator.writeKey(this._type);
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupDataframeAnalyticsStatsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::classificationStats, DataframeAnalyticsStatsHyperparameters._DESERIALIZER, CLASSIFICATION_STATS, new String[0]);
        op.add(Builder::outlierDetectionStats, DataframeAnalyticsStatsOutlierDetection._DESERIALIZER, OUTLIER_DETECTION_STATS, new String[0]);
        op.add(Builder::regressionStats, DataframeAnalyticsStatsHyperparameters._DESERIALIZER, REGRESSION_STATS, new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<DataframeAnalyticsStats> {
        private String _type;
        private Object _value;

        public Builder classificationStats(DataframeAnalyticsStatsHyperparameters v) {
            this._type = DataframeAnalyticsStats.CLASSIFICATION_STATS;
            this._value = v;
            return this;
        }

        public Builder classificationStats(Function<DataframeAnalyticsStatsHyperparameters.Builder, ObjectBuilder<DataframeAnalyticsStatsHyperparameters>> f) {
            return this.classificationStats(f.apply(new DataframeAnalyticsStatsHyperparameters.Builder()).build());
        }

        public Builder outlierDetectionStats(DataframeAnalyticsStatsOutlierDetection v) {
            this._type = DataframeAnalyticsStats.OUTLIER_DETECTION_STATS;
            this._value = v;
            return this;
        }

        public Builder outlierDetectionStats(Function<DataframeAnalyticsStatsOutlierDetection.Builder, ObjectBuilder<DataframeAnalyticsStatsOutlierDetection>> f) {
            return this.outlierDetectionStats(f.apply(new DataframeAnalyticsStatsOutlierDetection.Builder()).build());
        }

        public Builder regressionStats(DataframeAnalyticsStatsHyperparameters v) {
            this._type = DataframeAnalyticsStats.REGRESSION_STATS;
            this._value = v;
            return this;
        }

        public Builder regressionStats(Function<DataframeAnalyticsStatsHyperparameters.Builder, ObjectBuilder<DataframeAnalyticsStatsHyperparameters>> f) {
            return this.regressionStats(f.apply(new DataframeAnalyticsStatsHyperparameters.Builder()).build());
        }

        @Override
        public DataframeAnalyticsStats build() {
            return new DataframeAnalyticsStats(this);
        }
    }
}

