/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class Category
implements JsonpSerializable {
    private final Number categoryId;
    private final List<String> examples;
    @Nullable
    private final String grokPattern;
    private final String jobId;
    private final Number maxMatchingLength;
    @Nullable
    private final String partitionFieldName;
    @Nullable
    private final String partitionFieldValue;
    private final String regex;
    private final String terms;
    @Nullable
    private final Long numMatches;
    @Nullable
    private final List<String> preferredToCategories;
    @Nullable
    private final String p;
    private final String resultType;
    private final String mlcategory;
    public static final JsonpDeserializer<Category> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Category::setupCategoryDeserializer, Builder::build);

    public Category(Builder builder) {
        this.categoryId = Objects.requireNonNull(builder.categoryId, "category_id");
        this.examples = ModelTypeHelper.unmodifiableNonNull(builder.examples, "examples");
        this.grokPattern = builder.grokPattern;
        this.jobId = Objects.requireNonNull(builder.jobId, "job_id");
        this.maxMatchingLength = Objects.requireNonNull(builder.maxMatchingLength, "max_matching_length");
        this.partitionFieldName = builder.partitionFieldName;
        this.partitionFieldValue = builder.partitionFieldValue;
        this.regex = Objects.requireNonNull(builder.regex, "regex");
        this.terms = Objects.requireNonNull(builder.terms, "terms");
        this.numMatches = builder.numMatches;
        this.preferredToCategories = ModelTypeHelper.unmodifiable(builder.preferredToCategories);
        this.p = builder.p;
        this.resultType = Objects.requireNonNull(builder.resultType, "result_type");
        this.mlcategory = Objects.requireNonNull(builder.mlcategory, "mlcategory");
    }

    public Category(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public Number categoryId() {
        return this.categoryId;
    }

    public List<String> examples() {
        return this.examples;
    }

    @Nullable
    public String grokPattern() {
        return this.grokPattern;
    }

    public String jobId() {
        return this.jobId;
    }

    public Number maxMatchingLength() {
        return this.maxMatchingLength;
    }

    @Nullable
    public String partitionFieldName() {
        return this.partitionFieldName;
    }

    @Nullable
    public String partitionFieldValue() {
        return this.partitionFieldValue;
    }

    public String regex() {
        return this.regex;
    }

    public String terms() {
        return this.terms;
    }

    @Nullable
    public Long numMatches() {
        return this.numMatches;
    }

    @Nullable
    public List<String> preferredToCategories() {
        return this.preferredToCategories;
    }

    @Nullable
    public String p() {
        return this.p;
    }

    public String resultType() {
        return this.resultType;
    }

    public String mlcategory() {
        return this.mlcategory;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("category_id");
        generator.write(this.categoryId.doubleValue());
        generator.writeKey("examples");
        generator.writeStartArray();
        for (String item0 : this.examples) {
            generator.write(item0);
        }
        generator.writeEnd();
        if (this.grokPattern != null) {
            generator.writeKey("grok_pattern");
            generator.write(this.grokPattern);
        }
        generator.writeKey("job_id");
        generator.write(this.jobId);
        generator.writeKey("max_matching_length");
        generator.write(this.maxMatchingLength.doubleValue());
        if (this.partitionFieldName != null) {
            generator.writeKey("partition_field_name");
            generator.write(this.partitionFieldName);
        }
        if (this.partitionFieldValue != null) {
            generator.writeKey("partition_field_value");
            generator.write(this.partitionFieldValue);
        }
        generator.writeKey("regex");
        generator.write(this.regex);
        generator.writeKey("terms");
        generator.write(this.terms);
        if (this.numMatches != null) {
            generator.writeKey("num_matches");
            generator.write(this.numMatches.longValue());
        }
        if (this.preferredToCategories != null) {
            generator.writeKey("preferred_to_categories");
            generator.writeStartArray();
            for (String item0 : this.preferredToCategories) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.p != null) {
            generator.writeKey("p");
            generator.write(this.p);
        }
        generator.writeKey("result_type");
        generator.write(this.resultType);
        generator.writeKey("mlcategory");
        generator.write(this.mlcategory);
    }

    protected static void setupCategoryDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::categoryId, JsonpDeserializer.numberDeserializer(), "category_id", new String[0]);
        op.add(Builder::examples, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "examples", new String[0]);
        op.add(Builder::grokPattern, JsonpDeserializer.stringDeserializer(), "grok_pattern", new String[0]);
        op.add(Builder::jobId, JsonpDeserializer.stringDeserializer(), "job_id", new String[0]);
        op.add(Builder::maxMatchingLength, JsonpDeserializer.numberDeserializer(), "max_matching_length", new String[0]);
        op.add(Builder::partitionFieldName, JsonpDeserializer.stringDeserializer(), "partition_field_name", new String[0]);
        op.add(Builder::partitionFieldValue, JsonpDeserializer.stringDeserializer(), "partition_field_value", new String[0]);
        op.add(Builder::regex, JsonpDeserializer.stringDeserializer(), "regex", new String[0]);
        op.add(Builder::terms, JsonpDeserializer.stringDeserializer(), "terms", new String[0]);
        op.add(Builder::numMatches, JsonpDeserializer.longDeserializer(), "num_matches", new String[0]);
        op.add(Builder::preferredToCategories, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "preferred_to_categories", new String[0]);
        op.add(Builder::p, JsonpDeserializer.stringDeserializer(), "p", new String[0]);
        op.add(Builder::resultType, JsonpDeserializer.stringDeserializer(), "result_type", new String[0]);
        op.add(Builder::mlcategory, JsonpDeserializer.stringDeserializer(), "mlcategory", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<Category> {
        private Number categoryId;
        private List<String> examples;
        @Nullable
        private String grokPattern;
        private String jobId;
        private Number maxMatchingLength;
        @Nullable
        private String partitionFieldName;
        @Nullable
        private String partitionFieldValue;
        private String regex;
        private String terms;
        @Nullable
        private Long numMatches;
        @Nullable
        private List<String> preferredToCategories;
        @Nullable
        private String p;
        private String resultType;
        private String mlcategory;

        public Builder categoryId(Number value) {
            this.categoryId = value;
            return this;
        }

        public Builder examples(List<String> value) {
            this.examples = value;
            return this;
        }

        public Builder examples(String ... value) {
            this.examples = Arrays.asList(value);
            return this;
        }

        public Builder addExamples(String value) {
            if (this.examples == null) {
                this.examples = new ArrayList<String>();
            }
            this.examples.add(value);
            return this;
        }

        public Builder grokPattern(@Nullable String value) {
            this.grokPattern = value;
            return this;
        }

        public Builder jobId(String value) {
            this.jobId = value;
            return this;
        }

        public Builder maxMatchingLength(Number value) {
            this.maxMatchingLength = value;
            return this;
        }

        public Builder partitionFieldName(@Nullable String value) {
            this.partitionFieldName = value;
            return this;
        }

        public Builder partitionFieldValue(@Nullable String value) {
            this.partitionFieldValue = value;
            return this;
        }

        public Builder regex(String value) {
            this.regex = value;
            return this;
        }

        public Builder terms(String value) {
            this.terms = value;
            return this;
        }

        public Builder numMatches(@Nullable Long value) {
            this.numMatches = value;
            return this;
        }

        public Builder preferredToCategories(@Nullable List<String> value) {
            this.preferredToCategories = value;
            return this;
        }

        public Builder preferredToCategories(String ... value) {
            this.preferredToCategories = Arrays.asList(value);
            return this;
        }

        public Builder addPreferredToCategories(String value) {
            if (this.preferredToCategories == null) {
                this.preferredToCategories = new ArrayList<String>();
            }
            this.preferredToCategories.add(value);
            return this;
        }

        public Builder p(@Nullable String value) {
            this.p = value;
            return this;
        }

        public Builder resultType(String value) {
            this.resultType = value;
            return this;
        }

        public Builder mlcategory(String value) {
            this.mlcategory = value;
            return this;
        }

        @Override
        public Category build() {
            return new Category(this);
        }
    }
}

