/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class BucketInfluencer
implements JsonpSerializable {
    private final long bucketSpan;
    private final double influencerScore;
    private final String influencerFieldName;
    private final String influencerFieldValue;
    private final double initialInfluencerScore;
    private final boolean isInterim;
    private final String jobId;
    private final double probability;
    private final String resultType;
    private final String timestamp;
    @Nullable
    private final String foo;
    public static final JsonpDeserializer<BucketInfluencer> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, BucketInfluencer::setupBucketInfluencerDeserializer, Builder::build);

    public BucketInfluencer(Builder builder) {
        this.bucketSpan = Objects.requireNonNull(builder.bucketSpan, "bucket_span");
        this.influencerScore = Objects.requireNonNull(builder.influencerScore, "influencer_score");
        this.influencerFieldName = Objects.requireNonNull(builder.influencerFieldName, "influencer_field_name");
        this.influencerFieldValue = Objects.requireNonNull(builder.influencerFieldValue, "influencer_field_value");
        this.initialInfluencerScore = Objects.requireNonNull(builder.initialInfluencerScore, "initial_influencer_score");
        this.isInterim = Objects.requireNonNull(builder.isInterim, "is_interim");
        this.jobId = Objects.requireNonNull(builder.jobId, "job_id");
        this.probability = Objects.requireNonNull(builder.probability, "probability");
        this.resultType = Objects.requireNonNull(builder.resultType, "result_type");
        this.timestamp = Objects.requireNonNull(builder.timestamp, "timestamp");
        this.foo = builder.foo;
    }

    public BucketInfluencer(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public long bucketSpan() {
        return this.bucketSpan;
    }

    public double influencerScore() {
        return this.influencerScore;
    }

    public String influencerFieldName() {
        return this.influencerFieldName;
    }

    public String influencerFieldValue() {
        return this.influencerFieldValue;
    }

    public double initialInfluencerScore() {
        return this.initialInfluencerScore;
    }

    public boolean isInterim() {
        return this.isInterim;
    }

    public String jobId() {
        return this.jobId;
    }

    public double probability() {
        return this.probability;
    }

    public String resultType() {
        return this.resultType;
    }

    public String timestamp() {
        return this.timestamp;
    }

    @Nullable
    public String foo() {
        return this.foo;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("bucket_span");
        generator.write(this.bucketSpan);
        generator.writeKey("influencer_score");
        generator.write(this.influencerScore);
        generator.writeKey("influencer_field_name");
        generator.write(this.influencerFieldName);
        generator.writeKey("influencer_field_value");
        generator.write(this.influencerFieldValue);
        generator.writeKey("initial_influencer_score");
        generator.write(this.initialInfluencerScore);
        generator.writeKey("is_interim");
        generator.write(this.isInterim);
        generator.writeKey("job_id");
        generator.write(this.jobId);
        generator.writeKey("probability");
        generator.write(this.probability);
        generator.writeKey("result_type");
        generator.write(this.resultType);
        generator.writeKey("timestamp");
        generator.write(this.timestamp);
        if (this.foo != null) {
            generator.writeKey("foo");
            generator.write(this.foo);
        }
    }

    protected static void setupBucketInfluencerDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::bucketSpan, JsonpDeserializer.longDeserializer(), "bucket_span", new String[0]);
        op.add(Builder::influencerScore, JsonpDeserializer.doubleDeserializer(), "influencer_score", new String[0]);
        op.add(Builder::influencerFieldName, JsonpDeserializer.stringDeserializer(), "influencer_field_name", new String[0]);
        op.add(Builder::influencerFieldValue, JsonpDeserializer.stringDeserializer(), "influencer_field_value", new String[0]);
        op.add(Builder::initialInfluencerScore, JsonpDeserializer.doubleDeserializer(), "initial_influencer_score", new String[0]);
        op.add(Builder::isInterim, JsonpDeserializer.booleanDeserializer(), "is_interim", new String[0]);
        op.add(Builder::jobId, JsonpDeserializer.stringDeserializer(), "job_id", new String[0]);
        op.add(Builder::probability, JsonpDeserializer.doubleDeserializer(), "probability", new String[0]);
        op.add(Builder::resultType, JsonpDeserializer.stringDeserializer(), "result_type", new String[0]);
        op.add(Builder::timestamp, JsonpDeserializer.stringDeserializer(), "timestamp", new String[0]);
        op.add(Builder::foo, JsonpDeserializer.stringDeserializer(), "foo", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<BucketInfluencer> {
        private Long bucketSpan;
        private Double influencerScore;
        private String influencerFieldName;
        private String influencerFieldValue;
        private Double initialInfluencerScore;
        private Boolean isInterim;
        private String jobId;
        private Double probability;
        private String resultType;
        private String timestamp;
        @Nullable
        private String foo;

        public Builder bucketSpan(long value) {
            this.bucketSpan = value;
            return this;
        }

        public Builder influencerScore(double value) {
            this.influencerScore = value;
            return this;
        }

        public Builder influencerFieldName(String value) {
            this.influencerFieldName = value;
            return this;
        }

        public Builder influencerFieldValue(String value) {
            this.influencerFieldValue = value;
            return this;
        }

        public Builder initialInfluencerScore(double value) {
            this.initialInfluencerScore = value;
            return this;
        }

        public Builder isInterim(boolean value) {
            this.isInterim = value;
            return this;
        }

        public Builder jobId(String value) {
            this.jobId = value;
            return this;
        }

        public Builder probability(double value) {
            this.probability = value;
            return this;
        }

        public Builder resultType(String value) {
            this.resultType = value;
            return this;
        }

        public Builder timestamp(String value) {
            this.timestamp = value;
            return this;
        }

        public Builder foo(@Nullable String value) {
            this.foo = value;
            return this;
        }

        @Override
        public BucketInfluencer build() {
            return new BucketInfluencer(this);
        }
    }
}

