/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest.simulate;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class Document
implements JsonpSerializable {
    @Nullable
    private final String id;
    @Nullable
    private final String index;
    private final JsonData source;
    public static final JsonpDeserializer<Document> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Document::setupDocumentDeserializer, Builder::build);

    public Document(Builder builder) {
        this.id = builder.id;
        this.index = builder.index;
        this.source = Objects.requireNonNull(builder.source, "_source");
    }

    public Document(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public String id() {
        return this.id;
    }

    @Nullable
    public String index() {
        return this.index;
    }

    public JsonData source() {
        return this.source;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.id != null) {
            generator.writeKey("_id");
            generator.write(this.id);
        }
        if (this.index != null) {
            generator.writeKey("_index");
            generator.write(this.index);
        }
        generator.writeKey("_source");
        this.source.serialize(generator, mapper);
    }

    protected static void setupDocumentDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "_id", new String[0]);
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "_index", new String[0]);
        op.add(Builder::source, JsonData._DESERIALIZER, "_source", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<Document> {
        @Nullable
        private String id;
        @Nullable
        private String index;
        private JsonData source;

        public Builder id(@Nullable String value) {
            this.id = value;
            return this;
        }

        public Builder index(@Nullable String value) {
            this.index = value;
            return this;
        }

        public Builder source(JsonData value) {
            this.source = value;
            return this;
        }

        @Override
        public Document build() {
            return new Document(this);
        }
    }
}

