/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ingest.GetPipelineResponse;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class GetPipelineRequest
extends RequestBase {
    @Nullable
    private final String id;
    @Nullable
    private final String masterTimeout;
    @Nullable
    private final Boolean summary;
    public static final Endpoint<GetPipelineRequest, GetPipelineResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<GetPipelineRequest, GetPipelineResponse>(request -> "GET", request -> {
        boolean _id = true;
        boolean propsSet = false;
        if (request.id() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ingest");
            buf.append("/pipeline");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ingest");
            buf.append("/pipeline");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.id, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout);
        }
        if (request.summary != null) {
            params.put("summary", String.valueOf(request.summary));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, GetPipelineResponse._DESERIALIZER);

    public GetPipelineRequest(Builder builder) {
        this.id = builder.id;
        this.masterTimeout = builder.masterTimeout;
        this.summary = builder.summary;
    }

    public GetPipelineRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public String id() {
        return this.id;
    }

    @Nullable
    public String masterTimeout() {
        return this.masterTimeout;
    }

    @Nullable
    public Boolean summary() {
        return this.summary;
    }

    public static class Builder
    implements ObjectBuilder<GetPipelineRequest> {
        @Nullable
        private String id;
        @Nullable
        private String masterTimeout;
        @Nullable
        private Boolean summary;

        public Builder id(@Nullable String value) {
            this.id = value;
            return this;
        }

        public Builder masterTimeout(@Nullable String value) {
            this.masterTimeout = value;
            return this;
        }

        public Builder summary(@Nullable Boolean value) {
            this.summary = value;
            return this;
        }

        @Override
        public GetPipelineRequest build() {
            return new GetPipelineRequest(this);
        }
    }
}

