/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.stats;

import co.elastic.clients.elasticsearch.indices.stats.ShardLease;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class ShardRetentionLeases
implements JsonpSerializable {
    private final long primaryTerm;
    private final long version;
    private final List<ShardLease> leases;
    public static final JsonpDeserializer<ShardRetentionLeases> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ShardRetentionLeases::setupShardRetentionLeasesDeserializer, Builder::build);

    public ShardRetentionLeases(Builder builder) {
        this.primaryTerm = Objects.requireNonNull(builder.primaryTerm, "primary_term");
        this.version = Objects.requireNonNull(builder.version, "version");
        this.leases = ModelTypeHelper.unmodifiableNonNull(builder.leases, "leases");
    }

    public ShardRetentionLeases(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public long primaryTerm() {
        return this.primaryTerm;
    }

    public long version() {
        return this.version;
    }

    public List<ShardLease> leases() {
        return this.leases;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("primary_term");
        generator.write(this.primaryTerm);
        generator.writeKey("version");
        generator.write(this.version);
        generator.writeKey("leases");
        generator.writeStartArray();
        for (ShardLease item0 : this.leases) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupShardRetentionLeasesDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::primaryTerm, JsonpDeserializer.longDeserializer(), "primary_term", new String[0]);
        op.add(Builder::version, JsonpDeserializer.longDeserializer(), "version", new String[0]);
        op.add(Builder::leases, JsonpDeserializer.arrayDeserializer(ShardLease._DESERIALIZER), "leases", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ShardRetentionLeases> {
        private Long primaryTerm;
        private Long version;
        private List<ShardLease> leases;

        public Builder primaryTerm(long value) {
            this.primaryTerm = value;
            return this;
        }

        public Builder version(long value) {
            this.version = value;
            return this;
        }

        public Builder leases(List<ShardLease> value) {
            this.leases = value;
            return this;
        }

        public Builder leases(ShardLease ... value) {
            this.leases = Arrays.asList(value);
            return this;
        }

        public Builder addLeases(ShardLease value) {
            if (this.leases == null) {
                this.leases = new ArrayList<ShardLease>();
            }
            this.leases.add(value);
            return this;
        }

        public Builder leases(Function<ShardLease.Builder, ObjectBuilder<ShardLease>> fn) {
            return this.leases(fn.apply(new ShardLease.Builder()).build());
        }

        public Builder addLeases(Function<ShardLease.Builder, ObjectBuilder<ShardLease>> fn) {
            return this.addLeases(fn.apply(new ShardLease.Builder()).build());
        }

        @Override
        public ShardRetentionLeases build() {
            return new ShardRetentionLeases(this);
        }
    }
}

