/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.simulate_template;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class Overlapping
implements JsonpSerializable {
    private final String name;
    private final List<String> indexPatterns;
    public static final JsonpDeserializer<Overlapping> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Overlapping::setupOverlappingDeserializer, Builder::build);

    public Overlapping(Builder builder) {
        this.name = Objects.requireNonNull(builder.name, "name");
        this.indexPatterns = ModelTypeHelper.unmodifiableNonNull(builder.indexPatterns, "index_patterns");
    }

    public Overlapping(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String name() {
        return this.name;
    }

    public List<String> indexPatterns() {
        return this.indexPatterns;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("name");
        generator.write(this.name);
        generator.writeKey("index_patterns");
        generator.writeStartArray();
        for (String item0 : this.indexPatterns) {
            generator.write(item0);
        }
        generator.writeEnd();
    }

    protected static void setupOverlappingDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name", new String[0]);
        op.add(Builder::indexPatterns, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "index_patterns", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<Overlapping> {
        private String name;
        private List<String> indexPatterns;

        public Builder name(String value) {
            this.name = value;
            return this;
        }

        public Builder indexPatterns(List<String> value) {
            this.indexPatterns = value;
            return this;
        }

        public Builder indexPatterns(String ... value) {
            this.indexPatterns = Arrays.asList(value);
            return this;
        }

        public Builder addIndexPatterns(String value) {
            if (this.indexPatterns == null) {
                this.indexPatterns = new ArrayList<String>();
            }
            this.indexPatterns.add(value);
            return this;
        }

        @Override
        public Overlapping build() {
            return new Overlapping(this);
        }
    }
}

