/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.segments;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class ShardSegmentRouting
implements JsonpSerializable {
    private final String node;
    private final boolean primary;
    private final String state;
    public static final JsonpDeserializer<ShardSegmentRouting> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ShardSegmentRouting::setupShardSegmentRoutingDeserializer, Builder::build);

    public ShardSegmentRouting(Builder builder) {
        this.node = Objects.requireNonNull(builder.node, "node");
        this.primary = Objects.requireNonNull(builder.primary, "primary");
        this.state = Objects.requireNonNull(builder.state, "state");
    }

    public ShardSegmentRouting(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String node() {
        return this.node;
    }

    public boolean primary() {
        return this.primary;
    }

    public String state() {
        return this.state;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("node");
        generator.write(this.node);
        generator.writeKey("primary");
        generator.write(this.primary);
        generator.writeKey("state");
        generator.write(this.state);
    }

    protected static void setupShardSegmentRoutingDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::node, JsonpDeserializer.stringDeserializer(), "node", new String[0]);
        op.add(Builder::primary, JsonpDeserializer.booleanDeserializer(), "primary", new String[0]);
        op.add(Builder::state, JsonpDeserializer.stringDeserializer(), "state", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ShardSegmentRouting> {
        private String node;
        private Boolean primary;
        private String state;

        public Builder node(String value) {
            this.node = value;
            return this;
        }

        public Builder primary(boolean value) {
            this.primary = value;
            return this;
        }

        public Builder state(String value) {
            this.state = value;
            return this;
        }

        @Override
        public ShardSegmentRouting build() {
            return new ShardSegmentRouting(this);
        }
    }
}

