/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.ExpandWildcardOptions;
import co.elastic.clients.elasticsearch._types.Level;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.indices.StatsResponse;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class StatsRequest
extends RequestBase {
    @Nullable
    private final List<String> metric;
    @Nullable
    private final List<String> index;
    @Nullable
    private final List<String> completionFields;
    @Nullable
    private final List<ExpandWildcardOptions> expandWildcards;
    @Nullable
    private final List<String> fielddataFields;
    @Nullable
    private final List<String> fields;
    @Nullable
    private final Boolean forbidClosedIndices;
    @Nullable
    private final List<String> groups;
    @Nullable
    private final Boolean includeSegmentFileSizes;
    @Nullable
    private final Boolean includeUnloadedSegments;
    @Nullable
    private final Level level;
    @Nullable
    private final List<String> types;
    public static final Endpoint<StatsRequest, StatsResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<StatsRequest, StatsResponse>(request -> "GET", request -> {
        boolean _metric = true;
        int _index = 2;
        int propsSet = 0;
        if (request.metric() != null) {
            propsSet |= 1;
        }
        if (request.index() != null) {
            propsSet |= 2;
        }
        if (propsSet == 0) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_stats");
            return buf.toString();
        }
        if (propsSet == 1) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_stats");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.metric.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        if (propsSet == 2) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/_stats");
            return buf.toString();
        }
        if (propsSet == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/_stats");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.metric.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.completionFields != null) {
            params.put("completion_fields", request.completionFields.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (request.expandWildcards != null) {
            params.put("expand_wildcards", request.expandWildcards.stream().map(v -> v.toString()).collect(Collectors.joining(",")));
        }
        if (request.fielddataFields != null) {
            params.put("fielddata_fields", request.fielddataFields.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (request.fields != null) {
            params.put("fields", request.fields.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (request.forbidClosedIndices != null) {
            params.put("forbid_closed_indices", String.valueOf(request.forbidClosedIndices));
        }
        if (request.groups != null) {
            params.put("groups", request.groups.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (request.includeSegmentFileSizes != null) {
            params.put("include_segment_file_sizes", String.valueOf(request.includeSegmentFileSizes));
        }
        if (request.includeUnloadedSegments != null) {
            params.put("include_unloaded_segments", String.valueOf(request.includeUnloadedSegments));
        }
        if (request.level != null) {
            params.put("level", request.level.toString());
        }
        if (request.types != null) {
            params.put("types", request.types.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, StatsResponse._DESERIALIZER);

    public StatsRequest(Builder builder) {
        this.metric = ModelTypeHelper.unmodifiable(builder.metric);
        this.index = ModelTypeHelper.unmodifiable(builder.index);
        this.completionFields = ModelTypeHelper.unmodifiable(builder.completionFields);
        this.expandWildcards = ModelTypeHelper.unmodifiable(builder.expandWildcards);
        this.fielddataFields = ModelTypeHelper.unmodifiable(builder.fielddataFields);
        this.fields = ModelTypeHelper.unmodifiable(builder.fields);
        this.forbidClosedIndices = builder.forbidClosedIndices;
        this.groups = ModelTypeHelper.unmodifiable(builder.groups);
        this.includeSegmentFileSizes = builder.includeSegmentFileSizes;
        this.includeUnloadedSegments = builder.includeUnloadedSegments;
        this.level = builder.level;
        this.types = ModelTypeHelper.unmodifiable(builder.types);
    }

    public StatsRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public List<String> metric() {
        return this.metric;
    }

    @Nullable
    public List<String> index() {
        return this.index;
    }

    @Nullable
    public List<String> completionFields() {
        return this.completionFields;
    }

    @Nullable
    public List<ExpandWildcardOptions> expandWildcards() {
        return this.expandWildcards;
    }

    @Nullable
    public List<String> fielddataFields() {
        return this.fielddataFields;
    }

    @Nullable
    public List<String> fields() {
        return this.fields;
    }

    @Nullable
    public Boolean forbidClosedIndices() {
        return this.forbidClosedIndices;
    }

    @Nullable
    public List<String> groups() {
        return this.groups;
    }

    @Nullable
    public Boolean includeSegmentFileSizes() {
        return this.includeSegmentFileSizes;
    }

    @Nullable
    public Boolean includeUnloadedSegments() {
        return this.includeUnloadedSegments;
    }

    @Nullable
    public Level level() {
        return this.level;
    }

    @Nullable
    public List<String> types() {
        return this.types;
    }

    public static class Builder
    implements ObjectBuilder<StatsRequest> {
        @Nullable
        private List<String> metric;
        @Nullable
        private List<String> index;
        @Nullable
        private List<String> completionFields;
        @Nullable
        private List<ExpandWildcardOptions> expandWildcards;
        @Nullable
        private List<String> fielddataFields;
        @Nullable
        private List<String> fields;
        @Nullable
        private Boolean forbidClosedIndices;
        @Nullable
        private List<String> groups;
        @Nullable
        private Boolean includeSegmentFileSizes;
        @Nullable
        private Boolean includeUnloadedSegments;
        @Nullable
        private Level level;
        @Nullable
        private List<String> types;

        public Builder metric(@Nullable List<String> value) {
            this.metric = value;
            return this;
        }

        public Builder metric(String ... value) {
            this.metric = Arrays.asList(value);
            return this;
        }

        public Builder addMetric(String value) {
            if (this.metric == null) {
                this.metric = new ArrayList<String>();
            }
            this.metric.add(value);
            return this;
        }

        public Builder index(@Nullable List<String> value) {
            this.index = value;
            return this;
        }

        public Builder index(String ... value) {
            this.index = Arrays.asList(value);
            return this;
        }

        public Builder addIndex(String value) {
            if (this.index == null) {
                this.index = new ArrayList<String>();
            }
            this.index.add(value);
            return this;
        }

        public Builder completionFields(@Nullable List<String> value) {
            this.completionFields = value;
            return this;
        }

        public Builder completionFields(String ... value) {
            this.completionFields = Arrays.asList(value);
            return this;
        }

        public Builder addCompletionFields(String value) {
            if (this.completionFields == null) {
                this.completionFields = new ArrayList<String>();
            }
            this.completionFields.add(value);
            return this;
        }

        public Builder expandWildcards(@Nullable List<ExpandWildcardOptions> value) {
            this.expandWildcards = value;
            return this;
        }

        public Builder expandWildcards(ExpandWildcardOptions ... value) {
            this.expandWildcards = Arrays.asList(value);
            return this;
        }

        public Builder addExpandWildcards(ExpandWildcardOptions value) {
            if (this.expandWildcards == null) {
                this.expandWildcards = new ArrayList<ExpandWildcardOptions>();
            }
            this.expandWildcards.add(value);
            return this;
        }

        public Builder fielddataFields(@Nullable List<String> value) {
            this.fielddataFields = value;
            return this;
        }

        public Builder fielddataFields(String ... value) {
            this.fielddataFields = Arrays.asList(value);
            return this;
        }

        public Builder addFielddataFields(String value) {
            if (this.fielddataFields == null) {
                this.fielddataFields = new ArrayList<String>();
            }
            this.fielddataFields.add(value);
            return this;
        }

        public Builder fields(@Nullable List<String> value) {
            this.fields = value;
            return this;
        }

        public Builder fields(String ... value) {
            this.fields = Arrays.asList(value);
            return this;
        }

        public Builder addFields(String value) {
            if (this.fields == null) {
                this.fields = new ArrayList<String>();
            }
            this.fields.add(value);
            return this;
        }

        public Builder forbidClosedIndices(@Nullable Boolean value) {
            this.forbidClosedIndices = value;
            return this;
        }

        public Builder groups(@Nullable List<String> value) {
            this.groups = value;
            return this;
        }

        public Builder groups(String ... value) {
            this.groups = Arrays.asList(value);
            return this;
        }

        public Builder addGroups(String value) {
            if (this.groups == null) {
                this.groups = new ArrayList<String>();
            }
            this.groups.add(value);
            return this;
        }

        public Builder includeSegmentFileSizes(@Nullable Boolean value) {
            this.includeSegmentFileSizes = value;
            return this;
        }

        public Builder includeUnloadedSegments(@Nullable Boolean value) {
            this.includeUnloadedSegments = value;
            return this;
        }

        public Builder level(@Nullable Level value) {
            this.level = value;
            return this;
        }

        public Builder types(@Nullable List<String> value) {
            this.types = value;
            return this;
        }

        public Builder types(String ... value) {
            this.types = Arrays.asList(value);
            return this;
        }

        public Builder addTypes(String value) {
            if (this.types == null) {
                this.types = new ArrayList<String>();
            }
            this.types.add(value);
            return this;
        }

        @Override
        public StatsRequest build() {
            return new StatsRequest(this);
        }
    }
}

