/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.indices.GetTemplateResponse;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class GetTemplateRequest
extends RequestBase {
    @Nullable
    private final List<String> name;
    @Nullable
    private final Boolean flatSettings;
    @Nullable
    private final Boolean includeTypeName;
    @Nullable
    private final Boolean local;
    @Nullable
    private final String masterTimeout;
    public static final Endpoint<GetTemplateRequest, GetTemplateResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<GetTemplateRequest, GetTemplateResponse>(request -> "GET", request -> {
        boolean _name = true;
        boolean propsSet = false;
        if (request.name() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_template");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_template");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.name.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.flatSettings != null) {
            params.put("flat_settings", String.valueOf(request.flatSettings));
        }
        if (request.includeTypeName != null) {
            params.put("include_type_name", String.valueOf(request.includeTypeName));
        }
        if (request.local != null) {
            params.put("local", String.valueOf(request.local));
        }
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout);
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, GetTemplateResponse._DESERIALIZER);

    public GetTemplateRequest(Builder builder) {
        this.name = ModelTypeHelper.unmodifiable(builder.name);
        this.flatSettings = builder.flatSettings;
        this.includeTypeName = builder.includeTypeName;
        this.local = builder.local;
        this.masterTimeout = builder.masterTimeout;
    }

    public GetTemplateRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public List<String> name() {
        return this.name;
    }

    @Nullable
    public Boolean flatSettings() {
        return this.flatSettings;
    }

    @Nullable
    public Boolean includeTypeName() {
        return this.includeTypeName;
    }

    @Nullable
    public Boolean local() {
        return this.local;
    }

    @Nullable
    public String masterTimeout() {
        return this.masterTimeout;
    }

    public static class Builder
    implements ObjectBuilder<GetTemplateRequest> {
        @Nullable
        private List<String> name;
        @Nullable
        private Boolean flatSettings;
        @Nullable
        private Boolean includeTypeName;
        @Nullable
        private Boolean local;
        @Nullable
        private String masterTimeout;

        public Builder name(@Nullable List<String> value) {
            this.name = value;
            return this;
        }

        public Builder name(String ... value) {
            this.name = Arrays.asList(value);
            return this;
        }

        public Builder addName(String value) {
            if (this.name == null) {
                this.name = new ArrayList<String>();
            }
            this.name.add(value);
            return this;
        }

        public Builder flatSettings(@Nullable Boolean value) {
            this.flatSettings = value;
            return this;
        }

        public Builder includeTypeName(@Nullable Boolean value) {
            this.includeTypeName = value;
            return this;
        }

        public Builder local(@Nullable Boolean value) {
            this.local = value;
            return this;
        }

        public Builder masterTimeout(@Nullable String value) {
            this.masterTimeout = value;
            return this;
        }

        @Override
        public GetTemplateRequest build() {
            return new GetTemplateRequest(this);
        }
    }
}

